/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.integration.persistence;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.survey.shared.model.DBMultipleChoiceAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.MultipleChoiceAnswerId;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyQuestionId;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface SurveyDAO {
    public DBSurvey getSurveyById(SurveyId var1);

    public List<DBSurvey> getSurveysByParentId(GlobalId var1);

    public void insertSurveyBaseData(DBSurvey var1);

    public void updateSurveyBaseData(DBSurvey var1);

    public void deleteSurveysByIds(Iterable<SurveyId> var1);

    public void insertQuestionBaseData(DBSurveyQuestion var1);

    public void updateQuestionBaseData(DBSurveyQuestion var1);

    public void deleteQuestion(SurveyQuestionId var1);

    public void deleteQuestionsBySurveyId(SurveyId var1);

    public void insertMultipleChoiceAnswer(DBMultipleChoiceAnswer var1);

    public void insertMultipleChoiceAnswers(List<DBMultipleChoiceAnswer> var1);

    public void updateMultipleChoiceAnswer(DBMultipleChoiceAnswer var1);

    public void deleteMultipleChoiceAnswer(MultipleChoiceAnswerId var1);

    public void deleteParticipantAnswersByPersonIdAndSurveyId(PersonId var1, SurveyId var2);

    public ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersByPersonIdAndSurveyId(PersonId var1, SurveyId var2);

    @Nonnull
    public ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersBySurveyId(SurveyId var1);

    public void insertParticipantAnswers(List<DBSurveyParticipantAnswer> var1);

    public int getParticipantCount(SurveyId var1);

    public ImmutableList<SurveyId> getParticipatedSurveyIdsByPersonId(PersonId var1);

    @Nonnull
    public ImmutableList<DBSurvey> getSurveysByIds(Iterable<SurveyId> var1);

    public void deleteParticipantAnswersByPersonIdAndSurveyIds(PersonId var1, Iterable<SurveyId> var2);

    @Nonnull
    public ImmutableSet<SurveyId> getSurveyIdsByParentId(GlobalId var1);

    @CheckForNull
    public SurveyId getRedirectSurveyOnNewMembership(EntityId var1);
}

