/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.business.impl;

import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.CacheHelper;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteActionDescriptor;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityMembershipUpdateHandler;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.survey.business.events.SurveyPublishedEvent;
import de.justsoftware.onx.survey.integration.persistence.SurveyDAO;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.i18n.SurveyMessages;
import de.justsoftware.onx.survey.shared.model.DBMultipleChoiceAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import de.justsoftware.onx.survey.shared.model.QuestionSaveResult;
import de.justsoftware.onx.survey.shared.model.SurveyAnswerResult;
import de.justsoftware.onx.survey.shared.model.SurveyDetails;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyModuleData;
import de.justsoftware.onx.survey.shared.model.SurveyParticipantAnswerValidator;
import de.justsoftware.onx.survey.shared.model.SurveyQuestionId;
import de.justsoftware.onx.survey.shared.model.SurveyResult;
import de.justsoftware.onx.survey.shared.model.SurveyTeaser;
import de.justsoftware.onx.survey.shared.server.model.SurveyItem;
import de.justsoftware.toolbox.clock.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.util.StringUtils;

@Service
public class SurveyServiceImpl
implements SurveyService,
EntityMembershipUpdateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SurveyServiceImpl.class);
    @Autowired
    private MemcachedClientCache _cache;
    @Autowired
    private CacheHelper _cacheHelper;
    @Autowired
    private SurveyDAO _surveyDAO;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private TransactionHelper _transactionHelper;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private Clock _clock;

    @Override
    public SurveyId insertSurveyBaseData(PersonId personId, DBSurvey survey) throws ServiceException {
        if (survey == null || survey.getId() != null || survey.getParentId() == null) {
            throw new ServiceException("Illegal survey to insert");
        }
        survey.setOwnerId(personId);
        this._surveyDAO.insertSurveyBaseData(survey);
        this.deleteSurveyCache(survey);
        return survey.getId();
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
    }

    @Override
    public void create(ProfileItem parentProfileItem, ComponentType componentType, ServerEventCollector eventCollector) {
    }

    @Override
    public void deleteDependentSurveys(Iterable<SurveyId> surveyIds, GlobalId parentId, DeletionContext delectionContext) {
        if (CollectionUtil.isEmpty(surveyIds)) {
            return;
        }
        this._surveyDAO.deleteSurveysByIds(surveyIds);
        ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
        for (SurveyId surveyId : surveyIds) {
            keyBuilder.add((Object)this.createSurveyByIdCacheKey(surveyId));
            keyBuilder.add((Object)this.createParticipantAnswersBySurveyIdCacheKey(surveyId));
            keyBuilder.add((Object)this.createSurveyResultByIdCacheKey(surveyId));
        }
        keyBuilder.add((Object)this.createSurveyByParentIdCacheKey(parentId));
        ImmutableSet cacheKeys = keyBuilder.build();
        delectionContext.attach(() -> this._cacheHelper.delete((ImmutableSet<CacheKey>)cacheKeys));
    }

    private List<DBSurvey> getSurveyByParentId(GlobalId parentId) {
        CacheKey key = this.createSurveyByParentIdCacheKey(parentId);
        List<DBSurvey> result = (List<DBSurvey>)this._cache.get(key);
        if (result == null) {
            result = this._surveyDAO.getSurveysByParentId(parentId);
            this._cache.add(key, result);
        }
        return result;
    }

    private CacheKey createSurveyByParentIdCacheKey(GlobalId parentId) {
        return new CacheKey((CacheName)SurveyServiceCacheName.KEY_SURVEYS_BY_PARENT_ID, parentId);
    }

    @Override
    public boolean hasParticipateSurvey(PersonId personId, SurveyId surveyId) {
        if (personId == null) {
            return false;
        }
        return !CollectionUtil.isEmpty(this.getParticipantAnswersByPersonIdAndSurveyId(personId, surveyId));
    }

    @Override
    public DBSurvey getBySurveyId(SurveyId id) {
        CacheKey cacheKey = this.createSurveyByIdCacheKey(id);
        DBSurvey result = (DBSurvey)this._cache.get(cacheKey);
        if (result == null) {
            result = this._surveyDAO.getSurveyById(id);
            this._cache.add(cacheKey, result);
        }
        return result;
    }

    private CacheKey createSurveyByIdCacheKey(SurveyId id) {
        return new CacheKey((CacheName)SurveyServiceCacheName.KEY_SURVEY_BY_ID, id);
    }

    @Override
    public boolean isExpired(DBSurvey survey) {
        Date expiredDate = survey.getExpiredDate();
        return expiredDate != null && this._clock.nowDate().after(expiredDate);
    }

    @Override
    public void updateSurveyBaseData(DBSurvey survey) throws ServiceException {
        if (survey == null || survey.getId() == null || survey.getParentId() == null) {
            throw new ServiceException("Illegal survey to update");
        }
        DBSurvey fromDB = this.getBySurveyId(survey.getId());
        if (fromDB == null) {
            throw new ServiceException("Survey does not exists. Can't update not exisiting survey base data");
        }
        survey.setAnonym(fromDB.isAnonym());
        this._surveyDAO.updateSurveyBaseData(survey);
        this.deleteSurveyCache(survey);
    }

    @Override
    public QuestionSaveResult saveQuestions(final SurveyId id, final List<DBSurveyQuestion> questions, boolean forceSave, final AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        if (CollectionUtil.isEmpty(questions)) {
            throw new ServiceException("saveQuestions() with no questions to save called");
        }
        final DBSurvey survey = this.getBySurveyId(id);
        if (survey == null) {
            throw new InvalidIdServiceException("Survey with ID " + id + " does not exist (anymore)");
        }
        authorizationContext.check(new SurveyItem(survey), (Action)StaticAction.SURVEY_UPDATE);
        boolean wasUnpublished = CollectionUtil.isEmpty(survey.getQuestions());
        final QuestionSaveResult result = new QuestionSaveResult();
        result.setCountOfParticipants(this.getParticipantCount(id));
        if (result.getCountOfParticipants() > 0 && !forceSave) {
            result.setSaveSuccess(false);
            return result;
        }
        this.validateQuestions(questions);
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                SurveyServiceImpl.this.deleteQuestions(survey, authorizationContext.getUserId());
                ArrayList<DBMultipleChoiceAnswer> answers = new ArrayList<DBMultipleChoiceAnswer>(100);
                for (DBSurveyQuestion q : questions) {
                    q.setSurveyId(id);
                    SurveyServiceImpl.this._surveyDAO.insertQuestionBaseData(q);
                    if (q.isFreetextAnswer()) continue;
                    for (DBMultipleChoiceAnswer answer : q.getMultipleChoiceAnswers()) {
                        answer.setQuestionId(q.getId());
                        answers.add(answer);
                    }
                }
                SurveyServiceImpl.this._surveyDAO.insertMultipleChoiceAnswers(answers);
                result.setSaveSuccess(true);
            }
        });
        this.deleteSurveyCache(survey);
        if (wasUnpublished) {
            this._eventBus.post(new SurveyPublishedEvent(survey));
        }
        return result;
    }

    private void deleteQuestions(final @Nonnull DBSurvey survey, @Nonnull PersonId deletingPersonId) {
        if (survey.getQuestions().isEmpty()) {
            return;
        }
        this._deletionService.deleteInTransactionWithDeleteAction((ItemId)survey.getId(), deletingPersonId, DeleteActionDescriptor.SURVEY_QUESTIONS, new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                SurveyServiceImpl.this._surveyDAO.deleteQuestionsBySurveyId(survey.getId());
                return this;
            }
        });
    }

    private void validateQuestions(@Nonnull List<DBSurveyQuestion> questions) throws ServiceException {
        for (DBSurveyQuestion q : questions) {
            if (!StringUtils.hasText((String)q.getQuestion())) {
                throw new ServiceException("Question must not be blank");
            }
            if (!q.isFreetextAnswer()) {
                this.validateMultipleChoiceQuestion(q);
                continue;
            }
            q.setMultipleChoiceAnswers(null);
        }
    }

    private void validateMultipleChoiceQuestion(@Nonnull DBSurveyQuestion q) throws ServiceException {
        int max;
        if (CollectionUtil.isEmpty(q.getMultipleChoiceAnswers())) {
            throw new ServiceException("Question expected, but no question was defined");
        }
        for (DBMultipleChoiceAnswer next : q.getMultipleChoiceAnswers()) {
            if (StringUtils.hasText((String)next.getAnswer())) continue;
            throw new ServiceException("Answer must not be blank");
        }
        int min = q.getMinAnswers() == null ? 0 : q.getMinAnswers();
        int n = max = q.getMaxAnswers() == null ? q.getMultipleChoiceAnswers().size() : q.getMaxAnswers().intValue();
        if (min > max) {
            throw new ServiceException("min value must not be bigger than max value");
        }
        if (min > q.getMultipleChoiceAnswers().size() || max > q.getMultipleChoiceAnswers().size()) {
            throw new ServiceException("min/max value must not be bigger than the count of defined questions");
        }
    }

    private int getParticipantCount(SurveyId id) {
        return this._surveyDAO.getParticipantCount(id);
    }

    private void deleteSurveyCache(@Nonnull DBSurvey survey) {
        this._cache.delete(this.createSurveyByIdCacheKey(survey.getId()));
        this._cache.delete(this.createSurveyByParentIdCacheKey(survey.getParentId()));
        this.deleteParticipantAnswersCache(survey.getId());
    }

    @Override
    public void deleteSurvey(final SurveyId surveyId, AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        DBSurvey survey = this.getBySurveyId(surveyId);
        if (survey == null) {
            return;
        }
        authorizationContext.check(new SurveyItem(survey), (Action)StaticAction.SURVEY_DELETE);
        this._deletionService.deleteInTransactionWithDeleteAction(surveyId, authorizationContext.getUserId(), new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                SurveyServiceImpl.this._surveyDAO.deleteSurveysByIds((Iterable<SurveyId>)ImmutableSet.of((Object)surveyId));
                return this;
            }
        });
        this.deleteSurveyCache(survey);
    }

    @Override
    public void saveSurveyParticipantAnswers(SurveyId surveyId, List<DBSurveyParticipantAnswer> answers, AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        ImmutableSet<Action> may;
        PersonId personId = authorizationContext.getUserId();
        try {
            may = authorizationContext.may(this._itemService.getByIdNonNull(surveyId), (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticAction.SURVEY_PARTICIPATE, (Object)StaticAction.SURVEY_CHANGE_OWN_GIVEN_ANSWER));
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException();
        }
        if (!(may.contains(StaticAction.SURVEY_PARTICIPATE) || may.contains(StaticAction.SURVEY_CHANGE_OWN_GIVEN_ANSWER) && this.hasParticipateSurvey(personId, surveyId))) {
            throw new PermissionDeniedException();
        }
        DBSurvey survey = this.getBySurveyId(surveyId);
        if (survey == null) {
            throw new ServiceException("Survey does not exists");
        }
        if (this.isExpired(survey)) {
            throw new PermissionDeniedException("Survey is expired");
        }
        if (this.hasParticipateSurvey(personId, surveyId)) {
            if (!may.contains(StaticAction.SURVEY_CHANGE_OWN_GIVEN_ANSWER)) {
                throw new PermissionDeniedException();
            }
            this.deleteParticipantAnswersByPersonIdAndSurveyId(personId, surveyId);
        }
        HashMap<SurveyQuestionId, DBSurveyQuestion> questionsById = new HashMap<SurveyQuestionId, DBSurveyQuestion>(survey.getQuestions().size());
        for (DBSurveyQuestion question : survey.getQuestions()) {
            questionsById.put(question.getId(), question);
        }
        SurveyConstants surveyConstants = this._i18nService.createProxy(SurveyConstants.class, authorizationContext.getLocale());
        SurveyMessages surveyMessages = this._i18nService.createProxy(SurveyMessages.class, authorizationContext.getLocale());
        HashMap<DBSurveyQuestion, ArrayList<DBSurveyParticipantAnswer>> answersByQuestions = new HashMap<DBSurveyQuestion, ArrayList<DBSurveyParticipantAnswer>>(survey.getQuestions().size());
        for (DBSurveyParticipantAnswer dBSurveyParticipantAnswer : answers) {
            DBSurveyQuestion surveyQuestion = (DBSurveyQuestion)questionsById.get(dBSurveyParticipantAnswer.getQuestionId());
            if (surveyQuestion == null) {
                throw new IllegalStateException("The answers to save is not an answers for the given surveyId " + surveyId.getId());
            }
            dBSurveyParticipantAnswer.setParticipantId(personId);
            ArrayList<DBSurveyParticipantAnswer> list = (ArrayList<DBSurveyParticipantAnswer>)answersByQuestions.get(surveyQuestion);
            if (list == null) {
                list = new ArrayList<DBSurveyParticipantAnswer>();
                answersByQuestions.put(surveyQuestion, list);
            }
            list.add(dBSurveyParticipantAnswer);
        }
        for (Map.Entry entry : answersByQuestions.entrySet()) {
            try {
                SurveyParticipantAnswerValidator.validate((DBSurveyQuestion)entry.getKey(), (List)entry.getValue(), surveyConstants, surveyMessages);
            }
            catch (ValidationException e) {
                throw new ServiceException("Answers invalid: " + e.getMessage());
            }
        }
        this._surveyDAO.insertParticipantAnswers(answers);
        this.deleteSurveyCache(survey);
    }

    private void deleteParticipantAnswersByPersonIdAndSurveyId(final @Nonnull PersonId personId, final @Nonnull SurveyId surveyId) throws ServiceException {
        this._deletionService.deleteInTransactionWithDeleteAction((ItemId)surveyId, personId, DeleteActionDescriptor.SURVEY_PARTICIPANT_ANSWERS, new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                SurveyServiceImpl.this._surveyDAO.deleteParticipantAnswersByPersonIdAndSurveyId(personId, surveyId);
                return this;
            }
        });
        this.deleteParticipantAnswersCache(surveyId);
    }

    private ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersByPersonIdAndSurveyId(PersonId personId, SurveyId surveyId) {
        return this._surveyDAO.getParticipantAnswersByPersonIdAndSurveyId(personId, surveyId);
    }

    @Override
    public void deleteSurveyParticipantAnswers(SurveyId surveyId, AuthorizationCheckContextWithUserId authorizationContext) {
        authorizationContext.check((ItemId)surveyId, (Action)StaticAction.SURVEY_CHANGE_OWN_GIVEN_ANSWER);
        this.deleteParticipantAnswersByPersonIdAndSurveyId(authorizationContext.getUserId(), surveyId);
    }

    @Override
    public SurveyResult getSurveyResultById(SurveyId surveyId) {
        CacheKey key = this.createSurveyResultByIdCacheKey(surveyId);
        SurveyResult result = (SurveyResult)this._cache.get(key);
        if (result != null) {
            return result;
        }
        DBSurvey survey = this.getBySurveyId(surveyId);
        if (survey == null) {
            return null;
        }
        ImmutableList<DBSurveyParticipantAnswer> answers = this.getParticipantAnswersBySurveyId(surveyId);
        ImmutableListMultimap.Builder answerResultBuilder = ImmutableListMultimap.builder();
        ImmutableSetMultimap.Builder questionParticipants = ImmutableSetMultimap.builder();
        HashSet<PersonId> allParticipants = new HashSet<PersonId>(300);
        HashMap<Object, SurveyAnswerResult> answersResultByKey = new HashMap<Object, SurveyAnswerResult>(300);
        for (DBSurveyParticipantAnswer answer : answers) {
            allParticipants.add(answer.getParticipantId());
            SurveyAnswerResult answerResult = this.getAnswerResult((ImmutableListMultimap.Builder<SurveyQuestionId, SurveyAnswerResult>)answerResultBuilder, answersResultByKey, answer);
            answerResult.getAnsweredBy().put(answer.getParticipantId(), "");
            questionParticipants.put((Object)answer.getQuestionId(), (Object)answer.getParticipantId());
        }
        ImmutableMap<PersonId, DBPerson> simplePersonsMapByIds = survey.isAnonym() ? null : this._personService.getPersonsByIds(allParticipants);
        ImmutableListMultimap answerResults = answerResultBuilder.build();
        for (SurveyAnswerResult surveyAnswerResult : answerResults.values()) {
            surveyAnswerResult.setParticipantCount(surveyAnswerResult.getAnsweredBy().size());
            if (survey.isAnonym()) {
                surveyAnswerResult.setAnsweredBy(null);
                continue;
            }
            if (simplePersonsMapByIds == null) continue;
            for (PersonId personId : surveyAnswerResult.getAnsweredBy().keySet()) {
                DBPerson person = (DBPerson)simplePersonsMapByIds.get(personId);
                surveyAnswerResult.getAnsweredBy().put(personId, person.getFullName());
            }
        }
        SurveyResult newResult = new SurveyResult();
        newResult.setSurvey(survey);
        newResult.setParticipantCount(allParticipants.size());
        newResult.setAnswerResults((ImmutableListMultimap<SurveyQuestionId, SurveyAnswerResult>)answerResults);
        newResult.setQuestionParticipantCounts((ImmutableMultiset<SurveyQuestionId>)ImmutableMultiset.copyOf((Iterable)questionParticipants.build().keys()));
        this._cache.add(key, newResult);
        return newResult;
    }

    private CacheKey createSurveyResultByIdCacheKey(SurveyId surveyId) {
        return new CacheKey((CacheName)SurveyServiceCacheName.KEY_GET_SURVEY_RESULT, surveyId);
    }

    private SurveyAnswerResult getAnswerResult(ImmutableListMultimap.Builder<SurveyQuestionId, SurveyAnswerResult> answerResults, Map<Object, SurveyAnswerResult> answersResultByKey, DBSurveyParticipantAnswer answer) {
        if (StringUtils.hasLength((String)answer.getFreetextAnswer())) {
            String freetextKey = Joiner.on((String)":").join((Object)answer.getQuestionId(), (Object)answer.getFreetextAnswer().trim().toLowerCase(), new Object[0]);
            SurveyAnswerResult chached = answersResultByKey.get(freetextKey);
            if (chached != null) {
                return chached;
            }
            SurveyAnswerResult newAnswerResult = new SurveyAnswerResult();
            newAnswerResult.setFreetextAnswers(answer.getFreetextAnswer().trim());
            answersResultByKey.put(freetextKey, newAnswerResult);
            newAnswerResult.setAnsweredBy(new LinkedHashMap<PersonId, String>());
            answerResults.put((Object)answer.getQuestionId(), (Object)newAnswerResult);
            return newAnswerResult;
        }
        SurveyAnswerResult answerResult = answersResultByKey.get(answer.getMultipleChoiceAnswerId());
        if (answerResult != null) {
            return answerResult;
        }
        SurveyAnswerResult newAnswerResult = new SurveyAnswerResult();
        newAnswerResult.setMultipleChoiceAnswerId(answer.getMultipleChoiceAnswerId());
        answersResultByKey.put(answer.getMultipleChoiceAnswerId(), newAnswerResult);
        newAnswerResult.setAnsweredBy(new LinkedHashMap<PersonId, String>());
        answerResults.put((Object)answer.getQuestionId(), (Object)newAnswerResult);
        return newAnswerResult;
    }

    @Override
    public ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersBySurveyId(SurveyId surveyId, AuthorizationCheckContextWithUserId authorizationContext) {
        authorizationContext.check((ItemId)surveyId, (Action)StaticAction.SURVEY_READ_RESULT);
        return this.getParticipantAnswersBySurveyId(surveyId);
    }

    @Nonnull
    private ImmutableList<DBSurveyParticipantAnswer> getParticipantAnswersBySurveyId(@Nonnull SurveyId surveyId) {
        CacheKey cacheKey = this.createParticipantAnswersBySurveyIdCacheKey(surveyId);
        ImmutableList<DBSurveyParticipantAnswer> result = (ImmutableList<DBSurveyParticipantAnswer>)this._cache.get(cacheKey);
        if (result == null) {
            result = this._surveyDAO.getParticipantAnswersBySurveyId(surveyId);
            this._cache.add(cacheKey, result);
        }
        return result;
    }

    private CacheKey createParticipantAnswersBySurveyIdCacheKey(SurveyId surveyId) {
        return new CacheKey((CacheName)SurveyServiceCacheName.KEY_PARTICIPANT_ANSWERS_BY_SURVEY_ID, surveyId);
    }

    private void deleteParticipantAnswersCache(SurveyId surveyId) {
        this._cache.delete(this.createParticipantAnswersBySurveyIdCacheKey(surveyId));
        this._cache.delete(this.createSurveyResultByIdCacheKey(surveyId));
    }

    @Override
    public void onEntityMemberDelete(EntityId entityId, PersonId personId) {
        this.onEntityMembershipChange(entityId, personId, (ImmutableSet<EntityMemberRole>)ImmutableSet.of());
    }

    @Override
    public void onEntityMembershipChange(EntityId entityId, PersonId personId, ImmutableSet<EntityMemberRole> newRoles) {
        if (!EntityMemberRoles.hasMemberRights(newRoles)) {
            this.deleteParticipantAnswersIfNecessary(entityId, personId);
        }
    }

    private void deleteParticipantAnswersIfNecessary(EntityId entityId, PersonId personId) {
        ImmutableList<SurveyId> surveyIds = this._surveyDAO.getParticipatedSurveyIdsByPersonId(personId);
        Map<SurveyId, DBSurvey> surveys = this.getSurveysByIds((Collection<SurveyId>)surveyIds);
        HashSet<SurveyId> toDeleteSet = new HashSet<SurveyId>(surveys.size());
        for (Map.Entry<SurveyId, DBSurvey> entry : surveys.entrySet()) {
            DBSurvey survey = entry.getValue();
            if (!entityId.equals(survey.getParentId()) || !survey.isAutoDeleteAnswer()) continue;
            toDeleteSet.add(survey.getId());
        }
        this.deleteParticipantAnswersByPersonIdAndSurveyIds(personId, toDeleteSet);
    }

    @Override
    public Map<SurveyId, DBSurvey> getSurveysByIds(Collection<SurveyId> surveyIds) throws ServiceException {
        ArrayList<CacheKey> keys = new ArrayList<CacheKey>(surveyIds.size());
        for (SurveyId id : surveyIds) {
            keys.add(this.createSurveyByIdCacheKey(id));
        }
        Map cached = this._cache.getBulk(keys);
        ArrayList<SurveyId> tmpIds = new ArrayList<SurveyId>(surveyIds);
        Iterator it = tmpIds.iterator();
        HashMap<SurveyId, DBSurvey> map = new HashMap<SurveyId, DBSurvey>(tmpIds.size());
        while (it.hasNext()) {
            SurveyId id = (SurveyId)it.next();
            DBSurvey fromCache = (DBSurvey)cached.get(this.createSurveyByIdCacheKey(id));
            if (fromCache == null) continue;
            it.remove();
            map.put(id, fromCache);
        }
        if (!tmpIds.isEmpty()) {
            ImmutableList<DBSurvey> fromDB = this._surveyDAO.getSurveysByIds(tmpIds);
            for (DBSurvey survey : fromDB) {
                this._cache.add(this.createSurveyByIdCacheKey(survey.getId()), survey);
                map.put(survey.getId(), survey);
            }
        }
        return map;
    }

    private void deleteParticipantAnswersByPersonIdAndSurveyIds(PersonId personId, Collection<SurveyId> surveyIds) throws ServiceException {
        if (!CollectionUtil.isEmpty(surveyIds)) {
            this._surveyDAO.deleteParticipantAnswersByPersonIdAndSurveyIds(personId, surveyIds);
            for (SurveyId surveyId : surveyIds) {
                this.deleteParticipantAnswersCache(surveyId);
            }
        }
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) throws InvalidIDException {
        return this.getModuleData(authorizationContext, entity.getId());
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, ProfileItem person, ComponentType componentType) throws InvalidIDException {
        return this.getModuleData(authorizationContext, person.getId());
    }

    @Nonnull
    private ModuleData getModuleData(@Nonnull SearchAuthorizationCheckContext authorizationContext, @Nonnull GlobalId parentId) throws InvalidIDException {
        return new SurveyModuleData(parentId, 1, 0, this.getSurveyTeasersByParentId(parentId, 0, 1, authorizationContext), authorizationContext.may((ItemId)parentId, (Action)StaticAction.SURVEY_CREATE));
    }

    @Override
    public ListAndCount<SurveyTeaser> getSurveyTeasersByParentId(GlobalId parentId, int offset, int limit, AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        if (limit > 100) {
            throw new IllegalArgumentException("Limit over 100 not allowed");
        }
        List<DBSurvey> allSurveys = this.getSurveyByParentId(parentId);
        ListAndCount<DBSurvey> resultSurveys = CollectionUtil.nullSafeListAndCount(allSurveys, offset, limit);
        ListAndCount<SurveyTeaser> result = new ListAndCount<SurveyTeaser>(resultSurveys.size());
        result.setMaxCount(resultSurveys.getMaxCount());
        for (DBSurvey survey : resultSurveys) {
            result.add(this.getSurveyTeaser(survey, authorizationContext));
        }
        return result;
    }

    @Override
    public SurveyTeaser getSurveyTeaser(DBSurvey survey, AuthorizationCheckContextWithUserId authorizationContext) {
        SurveyTeaser s = new SurveyTeaser();
        this.initSurvey(authorizationContext, survey, s);
        return s;
    }

    private void initSurvey(AuthorizationCheckContextWithUserId authorizationContext, DBSurvey survey, SurveyTeaser toInit) throws ServiceException {
        PersonId personId = authorizationContext.getUserId();
        try {
            toInit.setAllowedActions(authorizationContext.may(this._itemService.getByIdNonNull(survey.getId()), (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticAction.SURVEY_DELETE, (Object)StaticAction.SURVEY_READ, (Object)StaticAction.SURVEY_CHANGE_OWN_GIVEN_ANSWER, (Object)StaticAction.SURVEY_PARTICIPATE, (Object)StaticAction.SURVEY_READ_RESULT, (Object)StaticAction.SURVEY_UPDATE, (Object[])new StaticAction[0])));
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException();
        }
        toInit.setTitle(survey.getTitle());
        toInit.setSurveyId(survey.getId());
        toInit.setOwner(this._profileTeaserService.getPersonTeaserByIdNonnull(survey.getOwnerId(), authorizationContext));
        if (toInit.getAllowedActions().contains((Object)StaticAction.SURVEY_READ)) {
            toInit.setSurveyData(survey);
            toInit.setExpired(this.isExpired(survey));
        }
        toInit.setCurrentUserAnswers(this.getParticipantAnswersByPersonIdAndSurveyId(personId, survey.getId()));
    }

    @Override
    public SurveyDetails getSurveyDetailsById(SurveyId surveyId, AuthorizationCheckContextWithUserId authorizationContext) throws ServiceException {
        EntityId parentEntityId;
        DBSurvey survey = this.getBySurveyId(surveyId);
        if (survey == null) {
            return null;
        }
        SurveyDetails result = new SurveyDetails();
        this.initSurvey(authorizationContext, survey, result);
        try {
            parentEntityId = this._itemService.getParentEntityId(new SurveyItem(survey));
            if (parentEntityId == null) {
                LOG.warn("Survey " + survey.getId() + " denotes invalid parent ID");
                return null;
            }
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException();
        }
        result.setParentEntity(InvalidIdServiceException.check(this._entityService.getInfoById(parentEntityId, authorizationContext)));
        result.setSurveyOwner(this._profileTeaserService.getPersonTeaserById(survey.getOwnerId(), authorizationContext));
        result.setParticipantCount(this.getParticipantCount(surveyId));
        return result;
    }

    @Override
    public ImmutableSet<SurveyId> getSurveyIdsByParentId(GlobalId parentId) {
        return this._surveyDAO.getSurveyIdsByParentId(parentId);
    }

    @Override
    public SurveyId getRedirectSurveyOnNewMembership(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        return this._surveyDAO.getRedirectSurveyOnNewMembership(entityId);
    }

    private static enum SurveyServiceCacheName implements CacheName
    {
        KEY_SURVEY_BY_ID("surveyById"),
        KEY_SURVEYS_BY_PARENT_ID("surveysByParentId"),
        KEY_PARTICIPANT_ANSWERS_BY_SURVEY_ID("getParticipantAnswersBySurveyId"),
        KEY_GET_SURVEY_RESULT("getSurveyResult");

        private final String _cacheName;

        private SurveyServiceCacheName(String cacheName) {
            this._cacheName = cacheName;
        }

        @Override
        public String getCacheName() {
            return this._cacheName;
        }
    }
}

