/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.survey.business.SurveyDeletionHandler;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SurveyDeletionHandlerImpl
implements SurveyDeletionHandler {
    @Autowired
    private SurveyService _surveyService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(Set<? extends ItemId> parentIds, DeletionContext deletionContext) {
        Iterable entityIds = Iterables.filter(parentIds, EntityId.class);
        for (EntityId entityId : entityIds) {
            ImmutableSet<SurveyId> surveyIdsToDelete = deletionContext.filterItemsNotYetDeleted(this._surveyService.getSurveyIdsByParentId(entityId));
            this._cascadeDeleteService.cascadeDelete((Set<? extends ItemId>)surveyIdsToDelete, deletionContext);
            this._surveyService.deleteDependentSurveys((Iterable<SurveyId>)surveyIdsToDelete, entityId, deletionContext);
        }
    }
}

