/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.storage.business.impl;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import de.justsoftware.onx.common.business.StorageServerConfig;
import de.justsoftware.onx.common.shared.util.Resources2;
import de.justsoftware.onx.storage.business.StorageServerService;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StorageServerServiceImpl
implements StorageServerService {
    private static final int TIMEOUT = 60000;
    private final String _imageServerUrl;
    private final StorageServerConfig _storageServerConfig;

    @ParametersAreNonnullByDefault
    @Autowired
    public StorageServerServiceImpl(@Value(value="${imageServerUrl}") String imageServerUrl, StorageServerConfig storageServerConfig) {
        Preconditions.checkArgument((!imageServerUrl.isEmpty() ? 1 : 0) != 0);
        this._imageServerUrl = imageServerUrl;
        this._storageServerConfig = storageServerConfig;
    }

    @Override
    public ByteSource loadFileFromStorageServer(String relPath) throws IOException {
        String fullPath = this._storageServerConfig.getUrlWithPath(relPath);
        if (fullPath.startsWith("http")) {
            return Resources2.asByteSource(new URL(fullPath), 60000);
        }
        return Files.asByteSource((File)new File(fullPath));
    }

    @Override
    public ByteSource loadIfFromStorageServer(String url) throws IOException {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (url.startsWith(this._imageServerUrl)) {
            return this.loadFileFromStorageServer(this.dropImageUrlPrefix(url));
        }
        return null;
    }

    @Nonnull
    private String dropImageUrlPrefix(String url) {
        return url.substring(this._imageServerUrl.length());
    }

    @Override
    public String absoluteInternalUrl(String path) {
        String relPath = path.startsWith(this._imageServerUrl) ? this.dropImageUrlPrefix(path) : path;
        return this._storageServerConfig.getUrlWithPath(relPath);
    }
}

