/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.social;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.social.SocialClientVersion;
import de.justsoftware.onx.social.SocialClientVersionCheckResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SocialClientVersionsService {
    public static final long ANDROID_MIN_APP_VERSION_CODE = 23100L;
    public static final long IOS_MIN_APP_VERSION_CODE = 2005001L;
    private static final Logger LOG = LoggerFactory.getLogger(SocialClientVersionsService.class);
    private static final Pattern ANDROID_SOCIAL_VERSION_CODE_PATTERN = Pattern.compile("\\bJustSocial/(\\d+)\\b.*\\(Android/.*");
    private static final Pattern IOS_SOCIAL_VERSION_CODE_PATTERN = Pattern.compile("\\bJustSocial/(\\d+\\.\\d+(?:\\.\\d+)?) Build/\\d+ iOS/");
    private static final Pattern IOS_SOCIAL_APP_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.(\\d+))?");

    @Nonnull
    public SocialClientVersionCheckResult checkVersion(SocialClientVersion version) {
        switch (version.getPlatform()) {
            case ANDROID: {
                if (version.getVersionCode() >= 23100L) {
                    return SocialClientVersionCheckResult.VALID_VERSION_CODE_CHECK_RESULT;
                }
                String androidErrorMessage = SocialClientVersionsService.errorMessage(SocialClientVersion.Platform.ANDROID, version.getVersionCode(), 23100L);
                return new SocialClientVersionCheckResult(true, androidErrorMessage);
            }
            case IOS: {
                if (version.getVersionCode() >= 2005001L) {
                    return SocialClientVersionCheckResult.VALID_VERSION_CODE_CHECK_RESULT;
                }
                String iosErrorMessage = SocialClientVersionsService.errorMessage(SocialClientVersion.Platform.IOS, version.getVersionCode(), 2005001L);
                return new SocialClientVersionCheckResult(true, iosErrorMessage);
            }
            case UNKNOWN: {
                return SocialClientVersionCheckResult.VALID_VERSION_CODE_CHECK_RESULT;
            }
        }
        return SocialClientVersionCheckResult.VALID_VERSION_CODE_CHECK_RESULT;
    }

    @Nonnull
    private static String errorMessage(SocialClientVersion.Platform platform, long versionCode, long minimumVersionCode) {
        return String.format("The app version code is too low. Found version %d, min version for %s is %d", versionCode, platform.displayName(), minimumVersionCode);
    }

    @Nonnull
    public static SocialClientVersion getVersion(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent == null) {
            return SocialClientVersion.UNKNOWN_PLATFORM_VERSION;
        }
        String androidVersionString = SocialClientVersionsService.findVersionCode(userAgent, ANDROID_SOCIAL_VERSION_CODE_PATTERN);
        if (androidVersionString != null) {
            return new SocialClientVersion(SocialClientVersion.Platform.ANDROID, SocialClientVersionsService.androidVersion(androidVersionString));
        }
        String iosVersionString = SocialClientVersionsService.findVersionCode(userAgent, IOS_SOCIAL_VERSION_CODE_PATTERN);
        if (iosVersionString != null) {
            return new SocialClientVersion(SocialClientVersion.Platform.IOS, SocialClientVersionsService.iosVersion(iosVersionString));
        }
        return SocialClientVersion.UNKNOWN_PLATFORM_VERSION;
    }

    private static long androidVersion(String versionCode) {
        try {
            return Long.parseLong(versionCode);
        }
        catch (NumberFormatException versionParseException) {
            LOG.warn("Version code \"" + versionCode + "\" cannot be parsed.");
            return -1L;
        }
    }

    private static long iosVersion(String versionCode) {
        Matcher matcher = IOS_SOCIAL_APP_VERSION_PATTERN.matcher(versionCode);
        if (!matcher.matches() || matcher.groupCount() < 3) {
            LOG.warn("Version code \"" + versionCode + "\" cannot be parsed.");
            return -1L;
        }
        String majorVersionString = matcher.group(1);
        String minorVersionString = matcher.group(2);
        String bugfixVersionString = (String)MoreObjects.firstNonNull((Object)matcher.group(3), (Object)"0");
        try {
            long version = Long.parseLong(majorVersionString);
            version *= 1000L;
            version += Long.parseLong(minorVersionString);
            version *= 1000L;
            return version += Long.parseLong(bugfixVersionString);
        }
        catch (NumberFormatException versionParseException) {
            LOG.warn("Version code \"" + versionCode + "\" cannot be parsed.");
            return -1L;
        }
    }

    @CheckForNull
    private static String findVersionCode(String userAgent, Pattern pattern) {
        Matcher matcher = pattern.matcher(userAgent);
        boolean found = matcher.find();
        return found ? matcher.group(1) : null;
    }
}

