/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.resource;

import de.justsoftware.onx.common.shared.util.StringUtil;
import freemarker.cache.URLTemplateLoader;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JucoTemplateLoader
extends URLTemplateLoader {
    private static final String SLASH = "/";
    private static final Logger LOG = LoggerFactory.getLogger(JucoTemplateLoader.class);
    private final String _prefix;

    public JucoTemplateLoader() {
        this("");
    }

    public JucoTemplateLoader(@Nonnull String prefix) {
        this._prefix = prefix;
    }

    protected URL getURL(String name) {
        String templatePath = this.createTemplatePath(name);
        URL configFileUrl = JucoTemplateLoader.class.getClassLoader().getResource(templatePath);
        if (configFileUrl != null) {
            return configFileUrl;
        }
        File file = new File(templatePath);
        if (!file.isFile()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            LOG.error(String.format("Failed to load template %s ", templatePath), (Throwable)e);
            return null;
        }
    }

    @Nonnull
    private String createTemplatePath(@Nonnull String name) {
        if (StringUtil.isEmpty(this._prefix)) {
            return name;
        }
        return name.startsWith(SLASH) ? this._prefix + name : this._prefix + SLASH + name;
    }
}

