/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.model;

import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.permission.client.model.CoreApp;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONArray;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class TenantKafkaDto {
    private final TenantId _tenantId;
    private final String _name;
    private final String _globalHighlightColor;
    private final String _logoId;
    private final List<String> _managers;
    private final Map<CoreApp, String> _appColors;
    private final Map<CoreApp, Boolean> _hasManualPermissions;

    private TenantKafkaDto(TenantId tenantId, String name, String globalHighlightColor, String logoId, List<String> managers, Map<CoreApp, String> appColors, Map<CoreApp, Boolean> hasManualPermissions) {
        this._tenantId = tenantId;
        this._name = name;
        this._globalHighlightColor = globalHighlightColor;
        this._logoId = logoId;
        this._managers = managers;
        this._appColors = appColors;
        this._hasManualPermissions = hasManualPermissions;
    }

    public TenantId getTenantId() {
        return this._tenantId;
    }

    public String toTopicJson() {
        return new JSONObject().put("id", (Object)this._tenantId.asString()).put("name", (Object)this._name).put("globalHighlightColor", (Object)this._globalHighlightColor).put("logoId", (Object)this._logoId).put("managers", (Object)new JSONArray(this._managers)).put("appColors", this._appColors).put("hasManualPermissions", this._hasManualPermissions).toString();
    }

    public String toString() {
        return "TenantKafkaDto{_tenantId=" + this._tenantId + ", _name='" + this._name + "', _globalHighlightColor='" + this._globalHighlightColor + "', _logoId='" + this._logoId + "', _managers=" + this._managers + ", _appColors=" + this._appColors + ", _hasManualPermissions=" + this._hasManualPermissions + "}";
    }

    public static class Builder {
        private TenantId _tenantId;
        private String _name;
        private String _globalHighlightColor;
        private String _logoId;
        private List<String> _managers;
        private Map<CoreApp, String> _appColors;
        private Map<CoreApp, Boolean> _hasManualPermissions;

        public TenantKafkaDto build() {
            return new TenantKafkaDto(this._tenantId, this._name, this._globalHighlightColor, this._logoId, this._managers, this._appColors, this._hasManualPermissions);
        }

        public Builder setTenantId(TenantId tenantId) {
            this._tenantId = tenantId;
            return this;
        }

        public Builder setName(String name) {
            this._name = name;
            return this;
        }

        public Builder setGlobalHighlightColor(String globalHighlightColor) {
            this._globalHighlightColor = globalHighlightColor;
            return this;
        }

        public Builder setLogoId(@Nullable String logoId) {
            this._logoId = logoId;
            return this;
        }

        public Builder setManagers(List<ProfileId> managers) {
            this._managers = managers.stream().map(ItemId::asString).collect(Collectors.toList());
            return this;
        }

        public Builder setAppColors(Map<CoreApp, String> appColors) {
            this._appColors = appColors;
            return this;
        }

        public Builder setHasManualPermissions(Map<CoreApp, Boolean> hasManualPermissions) {
            this._hasManualPermissions = hasManualPermissions;
            return this;
        }
    }
}

