/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.container.shared.model.Identifiable;
import de.justsoftware.onx.server.model.ComparableVersion;
import de.justsoftware.onx.server.model.JucoVersionId;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class JucoVersion
implements Identifiable<JucoVersionId> {
    private final JucoVersionId _id;
    private final String _versionString;

    public JucoVersion(JucoVersionId id, String versionString) {
        this._id = id;
        this._versionString = versionString;
    }

    @Override
    public JucoVersionId getId() {
        return this._id;
    }

    @Nonnull
    public String getVersionString() {
        return this._versionString;
    }

    public boolean isLowerThanOrEqualTo(String otherVersion) {
        return this.compareTo(otherVersion) <= 0;
    }

    public boolean isEqualTo(String otherVersion) {
        return this.compareTo(otherVersion) == 0;
    }

    public boolean isEqualToOrHigherThan(String otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public int compareTo(String otherVersion) {
        return new ComparableVersion(this._versionString).compareTo(new ComparableVersion(otherVersion));
    }

    public static int compareWithoutBuildNumber(String version, String otherVersion) {
        return new ComparableVersion(JucoVersion.getVersionWithoutBuildNumber(version)).compareTo(new ComparableVersion(JucoVersion.getVersionWithoutBuildNumber(otherVersion)));
    }

    @Nonnull
    private static String getVersionWithoutBuildNumber(String version) {
        int buildNumberIndex = version.indexOf(45);
        return buildNumberIndex < 0 ? version : version.substring(0, buildNumberIndex);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("versionString", (Object)this._versionString).toString();
    }
}

