/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.integration.persistence.ibatis;

import com.freiheit.toro.common.integration.persistence.ibatis.IbatisDAOUtil;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.server.integration.persistence.JucoVersionDAO;
import de.justsoftware.onx.server.integration.persistence.model.DBJucoVersion;
import de.justsoftware.onx.server.integration.persistence.model.DBJucoVersionUpdateProcess;
import de.justsoftware.onx.server.model.JucoVersionId;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcessStatus;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Repository
@ParametersAreNonnullByDefault
public class IbatisJucoVersionDAO
implements JucoVersionDAO {
    private static final String NAMESPACE = "JucoVersion";
    private final SqlMapClient _sqlMapClient;
    private final TransactionHelper _transactionHelper;
    private final IbatisStatementBuilder _stmtBuilder;

    @Autowired
    public IbatisJucoVersionDAO(@Qualifier(value="sqlMapClient") SqlMapClient sqlMapClient, TransactionHelper transactionHelper, StatementBuilderFactory stmtBuilderFactory) {
        this._sqlMapClient = sqlMapClient;
        this._transactionHelper = transactionHelper;
        this._stmtBuilder = stmtBuilderFactory.ibatistStatementBuilder(NAMESPACE);
    }

    @Override
    public DBJucoVersion getJucoVersion(final String hostname) {
        return this._transactionHelper.doInTransaction(new TransactionCallback<DBJucoVersion>(){

            public DBJucoVersion doInTransaction(TransactionStatus ts) {
                DBJucoVersion result = (DBJucoVersion)IbatisDAOUtil.wrappedQueryForObject(IbatisJucoVersionDAO.this._sqlMapClient, "JucoVersion.getJucoVersion", hostname);
                if (result != null) {
                    result.setProcesses((ImmutableSet<DBJucoVersionUpdateProcess>)ImmutableSet.copyOf((Collection)IbatisJucoVersionDAO.this.getProcesses((Set<JucoVersionId>)ImmutableSet.of((Object)result.getId())).get((Object)result.getId())));
                }
                return result;
            }
        });
    }

    @Override
    public ImmutableSet<String> getAllJucoVersions() {
        return IbatisDAOUtil.wrappedQueryForImmutableSet(this._sqlMapClient, "JucoVersion.getAllJucoVersions");
    }

    @Override
    public ImmutableMap<JucoVersionUpdateProcess, JucoVersionUpdateProcessStatus> getProcessesForVersion(JucoVersionId versionId) {
        return IbatisJucoVersionDAO.transformToProcessMap((Iterable<DBJucoVersionUpdateProcess>)this.getProcesses((Set<JucoVersionId>)ImmutableSet.of((Object)versionId)).get((Object)versionId));
    }

    @Nonnull
    private static ImmutableMap<JucoVersionUpdateProcess, JucoVersionUpdateProcessStatus> transformToProcessMap(Iterable<DBJucoVersionUpdateProcess> processes) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)FluentIterable.from(processes).uniqueIndex(DBJucoVersionUpdateProcess.TO_PROCESS), DBJucoVersionUpdateProcess.TO_STATUS));
    }

    @Nonnull
    private ImmutableMultimap<JucoVersionId, DBJucoVersionUpdateProcess> getProcesses(Set<JucoVersionId> ids) {
        return IbatisDAOUtil.wrappedPartitionQueryForMultimap(this._sqlMapClient, "JucoVersion.getJucoVersionProcesses", "jucoVersionId", ids, IbatisDAOUtil.IDS_TO_IBATIS_LIST);
    }

    @Override
    public void insertVersion(final DBJucoVersion jucoVersion) {
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IbatisJucoVersionDAO.this._stmtBuilder.insert("insertJucoVersion").param(jucoVersion);
                JucoVersionId id = jucoVersion.getId();
                if (id == null) {
                    throw new DAOException("Failed to insert juco version");
                }
                if (!CollectionUtil.isEmpty(jucoVersion.getProcesses())) {
                    IbatisJucoVersionDAO.this._stmtBuilder.insert("insertJucoVersionProcess").partition("processes", jucoVersion.getProcesses(), "id", id);
                }
            }
        });
    }

    @Override
    public int updateProcessStatus(JucoVersionId id, JucoVersionUpdateProcess process, JucoVersionUpdateProcessStatus status) {
        return (Integer)this._stmtBuilder.update("updateProcessStatus").param("id", id, "process", (Object)process, "status", (Object)status, "modifyAt", new Date());
    }

    @Override
    public ImmutableMap<JucoVersionUpdateProcess, DBJucoVersion> getLatestCompletedProcessesVersions(final String hostname) {
        return this._transactionHelper.doInTransaction(new TransactionCallback<ImmutableMap<JucoVersionUpdateProcess, DBJucoVersion>>(){

            public ImmutableMap<JucoVersionUpdateProcess, DBJucoVersion> doInTransaction(TransactionStatus ts) {
                ImmutableMap versions = ((IbatisStandardResultBuilder)IbatisJucoVersionDAO.this._stmtBuilder.select("getLatestCompletedProcessesVersions").param("hostname", Strings.nullToEmpty((String)hostname))).asMap("process", "version");
                final ImmutableMultimap<JucoVersionId, DBJucoVersionUpdateProcess> processes = IbatisJucoVersionDAO.this.getProcesses((Set<JucoVersionId>)FluentIterable.from((Iterable)versions.values()).transform(Identifiables.toId()).toSet());
                return ImmutableMap.copyOf((Map)Maps.transformValues(versions, (Function)new NullPermeableFunction<DBJucoVersion, DBJucoVersion>(){

                    @Override
                    protected DBJucoVersion applySafe(DBJucoVersion input) {
                        input.setProcesses((ImmutableSet<DBJucoVersionUpdateProcess>)ImmutableSet.copyOf((Collection)processes.get((Object)input.getId())));
                        return input;
                    }
                }));
            }
        });
    }
}

