/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import java.io.IOException;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ReindexSolrJucoServerVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReindexSolrJucoServerVersionUpdateProcessor.class);
    private final SolrClient _writeSolrServer;
    private final SearchService _searchService;
    private final SearchIndexService _searchIndexService;

    @Autowired
    public ReindexSolrJucoServerVersionUpdateProcessor(SearchService searchService, SearchIndexService searchIndexService, @Qualifier(value="writeSolrServer") SolrClient writeSolrServer) {
        this._searchService = searchService;
        this._searchIndexService = searchIndexService;
        this._writeSolrServer = writeSolrServer;
    }

    @Override
    public int getProcessorVersion() {
        return 1;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.REINDEX_SOLR;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "11.11");
    }

    @Override
    public boolean preconditionsMet() {
        try {
            this._writeSolrServer.ping();
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            LOG.warn("Reindexing solr not possible. Solr server is not ready ({}). We will retry it later.", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void process() {
        this._searchIndexService.fullImport((Set<FilterType>)this._searchService.getAllFilterTypes(), false);
    }
}

