/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import de.justsoftware.onx.admin.SuperAdminService;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ReindexSolrEntitiesJucoServerVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReindexSolrEntitiesJucoServerVersionUpdateProcessor.class);
    private final SolrClient _writeSolrServer;
    private final SuperAdminService _superAdminService;

    @Autowired
    public ReindexSolrEntitiesJucoServerVersionUpdateProcessor(@Qualifier(value="writeSolrServer") SolrClient writeSolrServer, SuperAdminService superAdminService) {
        this._superAdminService = superAdminService;
        this._writeSolrServer = writeSolrServer;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.REINDEX_SOLR_ENTITIES;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "11.11");
    }

    @Override
    public boolean preconditionsMet() {
        try {
            this._writeSolrServer.ping();
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            LOG.warn("Reindexing solr entities not possible. Solr server is not ready ({}). We will retry it later.", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void process() {
        this._superAdminService.reindexToro();
    }

    @Override
    public int getProcessorVersion() {
        return 2;
    }
}

