/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import java.io.IOException;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ReindexProfilesJucoServerVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReindexProfilesJucoServerVersionUpdateProcessor.class);
    private final SolrClient _writeSolrServer;
    private final SearchIndexService _searchIndexService;

    @Autowired
    public ReindexProfilesJucoServerVersionUpdateProcessor(SearchIndexService searchIndexService, @Qualifier(value="writeSolrServer") SolrClient writeSolrServer) {
        this._searchIndexService = searchIndexService;
        this._writeSolrServer = writeSolrServer;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.REINDEX_PROFILES_IN_COMMON_CORE;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "11.11");
    }

    @Override
    public boolean preconditionsMet() {
        try {
            this._writeSolrServer.ping();
        }
        catch (IOException | RuntimeException | SolrServerException e) {
            LOG.warn("Reindexing of profiles solr not possible. Solr server is not ready ({}). We will retry it later.", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void process() {
        this._searchIndexService.fullImport(Set.of(StaticFilterType.PROFILES), false);
    }
}

