/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import de.justsoftware.onx.people.business.PeopleInternalApiConnector;
import de.justsoftware.onx.person.business.PersonChangesPublisher;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PublishAllPersonChangeEventsUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private final PersonChangesPublisher _personChangePublisher;
    private final PersonTenantService _personTenantService;
    private final PeopleInternalApiConnector _peopleConnector;

    @Autowired
    public PublishAllPersonChangeEventsUpdateProcessor(PersonChangesPublisher personChangePublisher, PersonTenantService personTenantService, PeopleInternalApiConnector peopleConnector) {
        this._personChangePublisher = personChangePublisher;
        this._personTenantService = personTenantService;
        this._peopleConnector = peopleConnector;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.PUBLISH_PERSON_CHANGE_EVENTS;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "9.8.0-68");
    }

    @Override
    public boolean preconditionsMet() {
        return this._personChangePublisher.ready() && this._peopleConnector.hasSameJucoVersion();
    }

    @Override
    public void process() {
        this._personTenantService.republishAllPersonTenants();
        this._personChangePublisher.publishAllPersons();
    }

    @Override
    public int getProcessorVersion() {
        return 9;
    }
}

