/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.onx.server.business.ClusterConfiguration;
import de.justsoftware.onx.server.business.ClusterPosition;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.integration.persistence.JucoVersionDAO;
import de.justsoftware.onx.server.integration.persistence.model.DBJucoVersion;
import de.justsoftware.onx.server.integration.persistence.model.DBJucoVersionUpdateProcess;
import de.justsoftware.onx.server.model.JucoVersion;
import de.justsoftware.onx.server.model.JucoVersionId;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcessStatus;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class JucoServerVersionServiceImpl
implements JucoServerVersionService {
    private static final Logger LOG = LoggerFactory.getLogger(JucoServerVersionServiceImpl.class);
    private final ConcurrentMap<JucoVersionUpdateProcess, JucoServerVersionUpdateProcessor> _processorsByType = new ConcurrentHashMap<JucoVersionUpdateProcess, JucoServerVersionUpdateProcessor>();
    private final JucoVersionDAO _jucoVersionDAO;
    private final String _currentVersion;
    private final ScheduledExecutorService _executorService;
    private final String _hostname;
    private final ClusterConfiguration _clusterConfiguration;
    private final AtomicBoolean _updateProcessesFinished = new AtomicBoolean(false);

    @Autowired
    public JucoServerVersionServiceImpl(JucoVersionDAO jucoVersionDAO, ClusterConfiguration clusterConfiguration, @Value(value="${justconnect.version}") String currentVersion) throws UnknownHostException {
        this(jucoVersionDAO, clusterConfiguration, currentVersion, InetAddress.getLocalHost().getHostName(), Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("JucoServerVersionServiceImpl-%d").build()));
    }

    @VisibleForTesting
    JucoServerVersionServiceImpl(JucoVersionDAO jucoVersionDAO, ClusterConfiguration clusterConfiguration, String currentVersion, String hostname, ScheduledExecutorService executorService) {
        this._clusterConfiguration = clusterConfiguration;
        this._currentVersion = currentVersion;
        this._jucoVersionDAO = jucoVersionDAO;
        this._hostname = hostname;
        this._executorService = executorService;
    }

    @PreDestroy
    void onDestroy() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this._executorService, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Override
    public void register(JucoServerVersionUpdateProcessor jucoVersionUpdateProcessor) {
        this._processorsByType.put(jucoVersionUpdateProcessor.getProcessType(), jucoVersionUpdateProcessor);
    }

    @Nonnull
    private ImmutableSet<DBJucoVersionUpdateProcess> getProcesses(String newVersionString) {
        return FluentIterable.from(this._processorsByType.values()).filter(p -> p.getUpdateBehaviour().applyForNewVersion(newVersionString, new UpdateProcessInformationProviderImpl())).transform(p -> new DBJucoVersionUpdateProcess(p.getProcessType(), JucoVersionUpdateProcessStatus.REQUIRED, p.getProcessorVersion())).toSet();
    }

    @Override
    public void checkJucoVersionUpdate() {
        JucoVersionId versionToProcess = this.getVersionToProcess();
        this._executorService.execute(new StartUpdateProcessesRunnable(versionToProcess));
    }

    @Nonnull
    @VisibleForTesting
    JucoVersionId getVersionToProcess() {
        JucoVersion lastJucoVersion = JucoServerVersionServiceImpl.toJucoVersion(this._jucoVersionDAO.getJucoVersion(this._hostname));
        if (lastJucoVersion != null && lastJucoVersion.isEqualTo(this._currentVersion)) {
            LOG.info("No juco version change found. Current version is {}", (Object)this._currentVersion);
            return lastJucoVersion.getId();
        }
        LOG.info("Juco version update found: {} -> {}", (Object)(lastJucoVersion != null ? lastJucoVersion.getVersionString() : "unknown"), (Object)this._currentVersion);
        return this.createNewVersion(this._currentVersion);
    }

    @Nonnull
    private JucoVersionId createNewVersion(String newVersionString) {
        DBJucoVersion result = new DBJucoVersion();
        result.setVersion(newVersionString);
        result.setHostname(this._hostname);
        result.setCreateAt(new Date());
        result.setProcesses(this.getProcesses(newVersionString));
        this._jucoVersionDAO.insertVersion(result);
        return result.getId();
    }

    @CheckForNull
    private static JucoVersion toJucoVersion(@Nullable DBJucoVersion dbVersion) {
        return dbVersion != null ? new JucoVersion(dbVersion.getId(), dbVersion.getVersion()) : null;
    }

    @Override
    public String getCurrentVersion() {
        return this._currentVersion;
    }

    @Override
    public boolean isUpdateProcessCompleted(JucoVersionUpdateProcess process) {
        return this._jucoVersionDAO.getLatestCompletedProcessesVersions(null).containsKey((Object)process);
    }

    @Override
    public boolean hasPreviousVersionBelow(String version) {
        for (String previousVersion : this._jucoVersionDAO.getAllJucoVersions()) {
            if (JucoVersion.compareWithoutBuildNumber(previousVersion, version) >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllUpdateProcessesFinished() {
        return this._updateProcessesFinished.get();
    }

    @ParametersAreNonnullByDefault
    private final class UpdateProcessInformationProviderImpl
    implements UpdateBehaviour.UpdateProcessInformationProvider {
        private final ImmutableMap<JucoVersionUpdateProcess, DBJucoVersion> _latestCompletedProcessesVersionsOnAnyHost;
        private final ImmutableMap<JucoVersionUpdateProcess, DBJucoVersion> _latestCompletedProcessesVersionsOnCurrentHost;

        private UpdateProcessInformationProviderImpl() {
            this._latestCompletedProcessesVersionsOnAnyHost = JucoServerVersionServiceImpl.this._jucoVersionDAO.getLatestCompletedProcessesVersions(null);
            this._latestCompletedProcessesVersionsOnCurrentHost = JucoServerVersionServiceImpl.this._jucoVersionDAO.getLatestCompletedProcessesVersions(JucoServerVersionServiceImpl.this._hostname);
        }

        @Override
        public ClusterPosition getClusterPosition() {
            return JucoServerVersionServiceImpl.this._clusterConfiguration.getClusterPosition();
        }

        @Override
        public Optional<DBJucoVersionUpdateProcess> getLastExecutionOnAnyHost(JucoVersionUpdateProcess process) {
            return Optional.fromNullable((Object)((DBJucoVersion)this._latestCompletedProcessesVersionsOnAnyHost.get((Object)process))).transform(v -> (DBJucoVersionUpdateProcess)FluentIterable.from(v.getProcesses()).firstMatch(p -> p.getProcess() == process).orNull());
        }

        @Override
        public Optional<DBJucoVersionUpdateProcess> getLastExecutionOnCurrentHost(JucoVersionUpdateProcess process) {
            return Optional.fromNullable((Object)((DBJucoVersion)this._latestCompletedProcessesVersionsOnCurrentHost.get((Object)process))).transform(v -> (DBJucoVersionUpdateProcess)FluentIterable.from(v.getProcesses()).firstMatch(p -> p.getProcess() == process).orNull());
        }
    }

    @ParametersAreNonnullByDefault
    private class StartUpdateProcessesRunnable
    implements Runnable {
        private static final int RETRY_INTERVAL_IN_SECONDS = 30;
        private final JucoVersionId _versionToProcess;

        public StartUpdateProcessesRunnable(JucoVersionId versionId) {
            this._versionToProcess = versionId;
        }

        @Override
        public void run() {
            LOG.info("Start to check update processes.");
            for (JucoVersionUpdateProcess process : this.loadRequiredProcesses().keySet()) {
                try {
                    this.handleProcess(process);
                }
                catch (RuntimeException e) {
                    LOG.error("Got Exception during handle juco version update process " + process.name(), (Throwable)e);
                }
            }
            if (!this.loadRequiredProcesses().isEmpty()) {
                JucoServerVersionServiceImpl.this._executorService.schedule(this, 30L, TimeUnit.SECONDS);
            } else {
                JucoServerVersionServiceImpl.this._updateProcessesFinished.getAndSet(true);
                LOG.info("All required update processes triggered.");
            }
        }

        @Nonnull
        private Map<JucoVersionUpdateProcess, JucoVersionUpdateProcessStatus> loadRequiredProcesses() {
            return Maps.filterValues(JucoServerVersionServiceImpl.this._jucoVersionDAO.getProcessesForVersion(this._versionToProcess), (Predicate)Predicates.equalTo((Object)((Object)JucoVersionUpdateProcessStatus.REQUIRED)));
        }

        private void handleProcess(JucoVersionUpdateProcess process) {
            LOG.info("Check preconditions for juco version update process {}", (Object)process);
            JucoServerVersionUpdateProcessor updateProcessor = (JucoServerVersionUpdateProcessor)JucoServerVersionServiceImpl.this._processorsByType.get((Object)process);
            if (updateProcessor != null) {
                if (updateProcessor.preconditionsMet()) {
                    LOG.info("Start juco version update process {}", (Object)process);
                    updateProcessor.process();
                    JucoServerVersionServiceImpl.this._jucoVersionDAO.updateProcessStatus(this._versionToProcess, process, JucoVersionUpdateProcessStatus.COMPLETE);
                    LOG.info("Juco version update process {} successfully triggered", (Object)process);
                }
            } else {
                LOG.error("No update processor registered for juco version update process {}. Update process cannot be processed.", (Object)process);
            }
        }
    }
}

