/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.appswitcher.business.AppConfigService;
import de.justsoftware.onx.appswitcher.model.AppConfig;
import de.justsoftware.onx.appswitcher.shared.model.AppId;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.EverythingAllowedAuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.server.business.JucoServerVersionService;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.permission.client.model.Role;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@ParametersAreNonnullByDefault
@Service
@Lazy(value=false)
public class ActivateNewWikiAppVersionUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ActivateNewWikiAppVersionUpdateProcessor.class);
    private final JucoServerVersionService _jucoServerVersionService;
    private final AppConfigService _appConfigService;
    private final ThemeService _legacyThemeService;
    private final de.justsoftware.onx.tenantdesign.ThemeService _themeService;

    @Autowired
    public ActivateNewWikiAppVersionUpdateProcessor(AppConfigService appConfigService, JucoServerVersionService jucoServerVersionService, ThemeService themeService, de.justsoftware.onx.tenantdesign.ThemeService themeService1) {
        this._appConfigService = appConfigService;
        this._jucoServerVersionService = jucoServerVersionService;
        this._legacyThemeService = themeService;
        this._themeService = themeService1;
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.ACTIVATE_NEW_WIKI;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "11.11.0");
    }

    @Override
    public void process() {
        boolean useOldWikiAsProfileApp = !this._jucoServerVersionService.hasPreviousVersionBelow("11.11.0");
        LOG.info("Activate new Wiki with useOldWikiAsProfileApp = " + useOldWikiAsProfileApp + " started.");
        this.configureAppConfigs(useOldWikiAsProfileApp);
        this.configureAppVisibilities(useOldWikiAsProfileApp);
        this.configureAppColors(useOldWikiAsProfileApp);
        LOG.info("Activate new Wiki with useOldWikiAsProfileApp = " + useOldWikiAsProfileApp + " finish.");
    }

    private void configureAppConfigs(boolean useOldWikiAsProfileApp) {
        ImmutableList<AppConfig> currentAppConfigs = this._appConfigService.getAllAppConfigs();
        ImmutableList.Builder newAppConfigs = ImmutableList.builder();
        block6: for (AppConfig appConfig : currentAppConfigs) {
            CoreApp coreApp = CoreApp.byAppId(appConfig.getAppId());
            if (coreApp == null) {
                newAppConfigs.add((Object)appConfig);
                continue;
            }
            switch (coreApp) {
                case CONVERSATIONS: {
                    newAppConfigs.add((Object)this.coreAppConfig(coreApp, "Connect"));
                    continue block6;
                }
                case TASKS: {
                    newAppConfigs.add((Object)this.coreAppConfig(coreApp, "List"));
                    continue block6;
                }
                case WIKI: {
                    continue block6;
                }
                case SOCIAL: {
                    newAppConfigs.add((Object)this.coreAppConfig(CoreApp.WIKI, useOldWikiAsProfileApp ? "Wiki" : "Wiki Beta"));
                    newAppConfigs.add((Object)this.coreAppConfig(CoreApp.SOCIAL, useOldWikiAsProfileApp ? "Profile" : "Wiki"));
                    continue block6;
                }
            }
            newAppConfigs.add((Object)this.coreAppConfig(coreApp, StringUtils.capitalize((String)coreApp.getSimpleName())));
        }
        this._appConfigService.setAllAppConfigs((ImmutableList<AppConfig>)newAppConfigs.build());
    }

    private AppConfig coreAppConfig(CoreApp coreApp, String name) {
        return new AppConfig(coreApp.getAppId(), name, null, null, null, null, null);
    }

    private void configureAppVisibilities(boolean useOldWikiAsProfileApp) {
        ImmutableTable<Role, AppId, InitialVisibility> currentAppVisibilities = this._appConfigService.getInitialAppVisibilityConfigsByTenant(null);
        Role superadmin = Role.staticRole((String)"SUPERADMIN");
        HashMap<AppId, InitialVisibility> appVisibilitiesForAll = new HashMap<AppId, InitialVisibility>((Map<AppId, InitialVisibility>)currentAppVisibilities.row((Object)Role.ALL));
        HashMap<AppId, InitialVisibility> appVisibilitiesForSuperadmin = new HashMap<AppId, InitialVisibility>((Map<AppId, InitialVisibility>)currentAppVisibilities.row((Object)superadmin));
        if (useOldWikiAsProfileApp) {
            appVisibilitiesForAll.put(CoreApp.SOCIAL.getAppId(), InitialVisibility.INVISIBLE);
            appVisibilitiesForAll.put(CoreApp.WIKI.getAppId(), InitialVisibility.FORCED);
            appVisibilitiesForSuperadmin.remove(CoreApp.WIKI.getAppId());
        } else {
            appVisibilitiesForAll.put(CoreApp.SOCIAL.getAppId(), InitialVisibility.FORCED);
            appVisibilitiesForAll.remove(CoreApp.WIKI.getAppId());
            appVisibilitiesForSuperadmin.put(CoreApp.WIKI.getAppId(), InitialVisibility.FORCED);
        }
        this._appConfigService.setInitialAppVisibilityConfigsForRoleAndTenant(Role.ALL, null, (ImmutableMap<AppId, InitialVisibility>)ImmutableMap.copyOf(appVisibilitiesForAll));
        this._appConfigService.setInitialAppVisibilityConfigsForRoleAndTenant(superadmin, null, (ImmutableMap<AppId, InitialVisibility>)ImmutableMap.copyOf(appVisibilitiesForSuperadmin));
    }

    private void configureAppColors(boolean useOldWikiAsProfileApp) {
        Theme currentDefaultTheme;
        ThemeAttribute socialThemeColor;
        if (!useOldWikiAsProfileApp && ((socialThemeColor = (currentDefaultTheme = this._themeService.getLegacyTheme(null)).getAttribute(CoreApp.SOCIAL.getThemeAttributeType())) == null || socialThemeColor.getValue().equalsIgnoreCase("#42b392"))) {
            ThemeAttribute newSocialThemeColor = new ThemeAttribute(currentDefaultTheme.getId(), "#7cb342", CoreApp.SOCIAL.getThemeAttributeType());
            this._legacyThemeService.setDefaultThemeAttribute(newSocialThemeColor, EverythingAllowedAuthorizationCheckContext.INSTANCE);
        }
    }
}

