/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.server.business;

import com.google.common.base.Optional;
import de.justsoftware.onx.server.business.ApplyOnceOnAllNodesUpdateBehaviour;
import de.justsoftware.onx.server.business.ApplyOnceOnMasterUpdateBehaviour;
import de.justsoftware.onx.server.business.ClusterPosition;
import de.justsoftware.onx.server.business.JucoVersionUpdateProcessInfo;
import de.justsoftware.onx.server.integration.persistence.model.DBJucoVersionUpdateProcess;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface UpdateBehaviour {
    public static final UpdateBehaviour UPDATE_ALWAYS_ON_MASTER = new UpdateBehaviour(){

        @Override
        public boolean applyForNewVersion(String currentVersion, UpdateProcessInformationProvider historyProvider) {
            return historyProvider.getClusterPosition() == ClusterPosition.MASTER;
        }

        public boolean equals(Object other) {
            return other != null && other.getClass().equals(this.getClass());
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }
    };

    public boolean applyForNewVersion(String var1, UpdateProcessInformationProvider var2);

    @Nonnull
    public static UpdateBehaviour onceOnMasterForVersion(JucoVersionUpdateProcessInfo process, String minVersionToApplyFor) {
        return new ApplyOnceOnMasterUpdateBehaviour(process, minVersionToApplyFor);
    }

    @Nonnull
    public static UpdateBehaviour onceOnAllNodesForVersion(JucoVersionUpdateProcessInfo process, String minVersionToApplyFor) {
        return new ApplyOnceOnAllNodesUpdateBehaviour(process, minVersionToApplyFor);
    }

    @Nonnull
    public static UpdateBehaviour alwaysOnMaster() {
        return UPDATE_ALWAYS_ON_MASTER;
    }

    @ParametersAreNonnullByDefault
    public static interface UpdateProcessInformationProvider {
        @Nonnull
        public Optional<DBJucoVersionUpdateProcess> getLastExecutionOnAnyHost(JucoVersionUpdateProcess var1);

        @Nonnull
        public Optional<DBJucoVersionUpdateProcess> getLastExecutionOnCurrentHost(JucoVersionUpdateProcess var1);

        @Nonnull
        public ClusterPosition getClusterPosition();
    }
}

