/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.integration.persistence.mapper;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.model.DBFailedLoginCount;
import java.time.LocalDateTime;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;

@Mapper
@ParametersAreNonnullByDefault
public interface FailedLoginCountMapper {
    @ConstructorArgs(value={@Arg(javaType=PersonId.class, column="person_id"), @Arg(javaType=LocalDateTime.class, column="counted_since"), @Arg(javaType=int.class, column="failed_count")})
    @Select(value={"SELECT * FROM account_failed_logins WHERE person_id=#{personId}"})
    @ResultType(value=DBFailedLoginCount.class)
    @CheckForNull
    public DBFailedLoginCount getFailedLoginCountByPerson(@Param(value="personId") PersonId var1);

    @Insert(value={"<script><if test=\"_databaseId == 'ORACLE'\">MERGE INTO account_failed_logins USING dual ON (person_id = #{personId}) WHEN MATCHED THEN UPDATE SET counted_since = #{startOfObservation}, failed_count = #{count} WHEN NOT MATCHED THEN INSERT (person_id, counted_since, failed_count) VALUES (#{personId}, #{startOfObservation}, #{count})</if><if test=\"_databaseId == 'POSTGRES'\">INSERT INTO account_failed_logins(person_id, counted_since, failed_count) VALUES(#{personId}, #{startOfObservation}, #{count}) ON CONFLICT(person_id) DO UPDATE SET counted_since = #{startOfObservation}, failed_count = #{count} WHERE account_failed_logins.person_id = #{personId}</if></script>"})
    public void upsertFailedLoginAttemptWithObservationPeriodStart(@Param(value="personId") PersonId var1, @Param(value="startOfObservation") LocalDateTime var2, @Param(value="count") int var3);
}

