/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.integration.persistence.mapper;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.model.DBAccountLock;
import java.time.LocalDateTime;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;

@Mapper
@ParametersAreNonnullByDefault
public interface AccountLockMapper {
    @ConstructorArgs(value={@Arg(javaType=PersonId.class, column="person_id"), @Arg(javaType=LocalDateTime.class, column="locked_until")})
    @Select(value={"SELECT * FROM account_lock WHERE #{personId} = person_id"})
    @ResultType(value=DBAccountLock.class)
    @CheckForNull
    public DBAccountLock getAccountLockByPerson(@Param(value="personId") PersonId var1);

    @Insert(value={"<script><if test=\"_databaseId == 'ORACLE'\">MERGE INTO account_lock USING dual ON (person_id = #{personId})WHEN MATCHED THEN UPDATE SET locked_until = #{lockedUntil}WHEN NOT MATCHED THEN INSERT (person_id, locked_until) VALUES (#{personId}, #{lockedUntil})</if><if test=\"_databaseId == 'POSTGRES'\">INSERT INTO account_lock(person_id, locked_until) VALUES (#{personId}, #{lockedUntil})ON CONFLICT(person_id) DO UPDATE SET locked_until = #{lockedUntil}WHERE account_lock.person_id = #{personId}</if></script>"})
    public void upsertAccountLockForPerson(@Param(value="personId") PersonId var1, @Param(value="lockedUntil") LocalDateTime var2);

    @Delete(value={"DELETE FROM account_lock WHERE person_id = #{personId}"})
    public void deleteAccountLockForPerson(@Param(value="personId") PersonId var1);
}

