/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.integration.persistence;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.FailedLoginCountDAO;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.mapper.FailedLoginCountMapper;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.model.DBFailedLoginCount;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class FailedLoginCountDAOImpl
implements FailedLoginCountDAO {
    private final FailedLoginCountMapper _mapper;

    @Autowired
    public FailedLoginCountDAOImpl(FailedLoginCountMapper mapper) {
        this._mapper = mapper;
    }

    @Override
    public Optional<DBFailedLoginCount> getByPerson(PersonId personId) {
        return Optional.ofNullable(this._mapper.getFailedLoginCountByPerson(personId));
    }

    @Override
    public DBFailedLoginCount saveOrUpdate(PersonId personId, LocalDateTime observationPeriodStart, int failedCount) {
        this._mapper.upsertFailedLoginAttemptWithObservationPeriodStart(personId, observationPeriodStart, failedCount);
        return Objects.requireNonNull(this._mapper.getFailedLoginCountByPerson(personId));
    }
}

