/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.business.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.model.DBFailedLoginCount;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class FailedLoginCount
extends AbstractImmutableEqualsObject {
    private final ProfileId _profileId;
    private final LocalDateTime _countedSince;
    private final int _failCount;

    public FailedLoginCount(ProfileId profileId, LocalDateTime countedSince, int failCount) {
        super(profileId, countedSince, failCount);
        this._profileId = profileId;
        this._countedSince = countedSince;
        this._failCount = failCount;
    }

    @Nonnull
    public ProfileId getProfileId() {
        return this._profileId;
    }

    @Nonnull
    public LocalDateTime getCountedSince() {
        return this._countedSince;
    }

    @Nonnull
    public int getFailCount() {
        return this._failCount;
    }

    @Nonnull
    public static FailedLoginCount from(DBFailedLoginCount dbObject) {
        return new FailedLoginCount(dbObject.getPersonId().asProfileId(), dbObject.getCountedSince(), dbObject.getFailCount());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("profileId", (Object)this._profileId).add("countedSince", (Object)this._countedSince).add("failCount", this._failCount).toString();
    }
}

