/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.business.impl;

import com.google.common.base.Strings;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.security.trusteddevice.business.AccountLockService;
import de.justsoftware.onx.security.trusteddevice.business.FailedLoginCountService;
import de.justsoftware.onx.security.trusteddevice.business.TrustedDeviceService;
import de.justsoftware.onx.security.trusteddevice.business.TrustedDeviceTokenService;
import de.justsoftware.onx.security.trusteddevice.business.model.FailedLoginCount;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TrustedDeviceServiceImpl
implements TrustedDeviceService {
    private static final Logger AUTHENTICATION_LOGGER = LoggerFactory.getLogger((String)"AUTHENTICATIONLOG");
    private final Clock _clock;
    private final FailedLoginCountService _failedLoginCountService;
    private final AccountLockService _accountLockService;
    private final TrustedDeviceTokenService _tokenService;
    private final PersonService _personService;

    @Autowired
    public TrustedDeviceServiceImpl(@Qualifier(value="javaTimeClock") Clock clock, FailedLoginCountService failedLoginCountService, AccountLockService accountLockService, TrustedDeviceTokenService trustedDeviceTokenService, PersonService personService) {
        this._clock = clock;
        this._failedLoginCountService = failedLoginCountService;
        this._accountLockService = accountLockService;
        this._tokenService = trustedDeviceTokenService;
        this._personService = personService;
    }

    @Override
    public void handleFailedLoginAttempt(ProfileId profileId) {
        LocalDateTime now = LocalDateTime.now(this._clock);
        FailedLoginCount failedLoginCount = this._failedLoginCountService.countFailedLoginAttempt(profileId, now);
        AUTHENTICATION_LOGGER.info("Failed login attempt. {}", (Object)failedLoginCount.toString());
        this._accountLockService.lockAccountIfNecessary(failedLoginCount);
    }

    @Override
    public boolean accountMayLogIn(ProfileId profileId, @Nullable String trustedDeviceToken) {
        boolean accountIsLocked = this._accountLockService.isAccountLocked(profileId);
        if (trustedDeviceToken == null || !accountIsLocked) {
            return !accountIsLocked;
        }
        return this._tokenService.isTokenValidForUser(trustedDeviceToken, profileId);
    }

    @Override
    public boolean accountMayLogIn(String loginNameOrEmail, @Nullable String trustedDeviceToken) {
        return this.getUserFromLogin(loginNameOrEmail).map(profileId -> this.accountMayLogIn((ProfileId)profileId, trustedDeviceToken)).orElse(true);
    }

    @Nonnull
    private Optional<ProfileId> getUserFromLogin(@Nullable String loginMail) {
        if (Strings.nullToEmpty((String)loginMail).isBlank()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this._personService.getPersonByEmail(loginMail)).map(dbPerson -> dbPerson.getId().asProfileId());
    }

    @Override
    public Optional<String> issueTrustedDeviceToken(ProfileId profileId, Duration lifetime) {
        return this._tokenService.issueToken(profileId, lifetime);
    }
}

