/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.business.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.security.trusteddevice.business.FailedLoginCountService;
import de.justsoftware.onx.security.trusteddevice.business.model.FailedLoginCount;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.FailedLoginCountDAO;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.model.DBFailedLoginCount;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FailedLoginCountServiceImpl
implements FailedLoginCountService {
    private final int _observationDurationMinutes;
    private final FailedLoginCountDAO _dao;

    @Autowired
    public FailedLoginCountServiceImpl(FailedLoginCountDAO dao, @Value(value="${just.security.failedLogin.observationMinutes:10}") int observationDurationMinutes) {
        this._dao = dao;
        this._observationDurationMinutes = observationDurationMinutes;
    }

    @Nonnull
    public Optional<FailedLoginCount> getFailedLoginAttemptsForUser(ProfileId profileId) {
        return this._dao.getByPerson(profileId.asPersonId()).map(FailedLoginCount::from).or(Optional::empty);
    }

    @Override
    public FailedLoginCount countFailedLoginAttempt(ProfileId profileId, LocalDateTime timestamp) {
        PersonId personId = profileId.asPersonId();
        return FailedLoginCount.from(this._dao.getByPerson(personId).map(existing -> this.updateExistingAttemptCount((DBFailedLoginCount)((Object)existing), timestamp)).orElseGet(() -> this.createNewAttemptCount(personId, timestamp)));
    }

    @Nonnull
    private DBFailedLoginCount updateExistingAttemptCount(DBFailedLoginCount existingAttemptCount, LocalDateTime timestamp) {
        return this.hasPreviousObservationPeriodEnded(existingAttemptCount.getCountedSince(), timestamp) ? this.createNewAttemptCount(existingAttemptCount.getPersonId(), timestamp) : this.updateAttemptCount(existingAttemptCount);
    }

    @Nonnull
    private DBFailedLoginCount updateAttemptCount(DBFailedLoginCount existingAttemptCount) {
        return this._dao.saveOrUpdate(existingAttemptCount.getPersonId(), existingAttemptCount.getCountedSince(), existingAttemptCount.getFailCount() + 1);
    }

    @Nonnull
    private DBFailedLoginCount createNewAttemptCount(PersonId personId, LocalDateTime timestamp) {
        return this._dao.saveOrUpdate(personId, timestamp, 1);
    }

    private boolean hasPreviousObservationPeriodEnded(LocalDateTime observationStart, LocalDateTime now) {
        return observationStart.until(now, ChronoUnit.MINUTES) > (long)this._observationDurationMinutes;
    }
}

