/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.trusteddevice.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.security.trusteddevice.business.AccountLockService;
import de.justsoftware.onx.security.trusteddevice.business.model.FailedLoginCount;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.AccountLockDAO;
import de.justsoftware.onx.security.trusteddevice.integration.persistence.model.DBAccountLock;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class AccountLockServiceImpl
implements AccountLockService {
    private static final Logger AUTHENTICATION_LOGGER = LoggerFactory.getLogger((String)"AUTHENTICATIONLOG");
    private final Clock _clock;
    private final AccountLockDAO _accountLockDAO;
    private final Settings _settings;
    private final int _maxFailedAttempts;
    private final int _lockoutMinutes;

    public AccountLockServiceImpl(@Qualifier(value="javaTimeClock") Clock clock, AccountLockDAO accountLockDAO, @Value(value="${just.security.failedLogin.maxAttempts:5}") int maxFailedAttempts, @Value(value="${just.security.failedLogin.lockoutMinutes:60}") int lockoutMinutes, Settings settings) {
        this._clock = clock;
        this._accountLockDAO = accountLockDAO;
        this._maxFailedAttempts = maxFailedAttempts;
        this._lockoutMinutes = lockoutMinutes;
        this._settings = settings;
    }

    @Override
    public void lockAccountIfNecessary(FailedLoginCount failedLoginCount) {
        if (failedLoginCount.getFailCount() > this._maxFailedAttempts) {
            PersonId personId = failedLoginCount.getProfileId().asPersonId();
            this._accountLockDAO.insertOrUpdateAccountLock(personId, LocalDateTime.now(this._clock).plusMinutes(this._lockoutMinutes));
            AUTHENTICATION_LOGGER.warn("{}'s account is locked for {} minutes.", (Object)personId.asProfileId(), (Object)this._lockoutMinutes);
        }
    }

    @Override
    public boolean isAccountLocked(ProfileId profileId) {
        if (!this._settings.isAccountLockEnabled()) {
            return false;
        }
        Optional<DBAccountLock> lock = this._accountLockDAO.getAccountLockForPerson(profileId.asPersonId());
        if (lock.isPresent()) {
            boolean isExpired = LocalDateTime.now(this._clock).isAfter(lock.get().getLockedUntil());
            return !isExpired;
        }
        return false;
    }
}

