/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PersonReadWriteDataService;
import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PasswordMigrationUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordMigrationUpdateProcessor.class);
    private final PersonReadWriteDataService _personReadWriteDataService;
    private final JucoPasswordEncoder _jucoPasswordEncoder;

    @Autowired
    public PasswordMigrationUpdateProcessor(PersonReadWriteDataService personReadWriteDataService, JucoPasswordEncoder jucoPasswordEncoder) {
        this._personReadWriteDataService = personReadWriteDataService;
        this._jucoPasswordEncoder = jucoPasswordEncoder;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "11.2");
    }

    @Override
    public void process() {
        int count = 0;
        while (this._personReadWriteDataService.getPersonWithMd5Password(this::migratePassword)) {
            ++count;
        }
        LOG.info(count + " MD5 passwords migrated!");
    }

    private void migratePassword(PersonId id, String oldHashedPassword) {
        String newHashedPassword = this._jucoPasswordEncoder.hashMd5Password(oldHashedPassword);
        this._personReadWriteDataService.updatePassword(id, oldHashedPassword, newHashedPassword);
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.MIGRATE_PASSWORDS;
    }
}

