/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.push.business.PushNotificationService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenService;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.service.MobileLogoutService;
import de.justsoftware.onx.zookeeper.OpenIdLoginConfiguration;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobileLogoutServiceImpl
implements MobileLogoutService {
    private static final OAuthClientId OLD_MOBILE_CLIENT = new OAuthClientId("mobile-apps");
    private final OAuthTokenService _oAuthTokenService;
    private final PushNotificationService _pushNotificationService;
    private final OpenIdLoginConfiguration _openIdLoginConfiguration;

    @Autowired
    public MobileLogoutServiceImpl(OAuthTokenService oAuthTokenService, PushNotificationService pushNotificationService, OpenIdLoginConfiguration openIdLoginConfiguration) {
        this._oAuthTokenService = oAuthTokenService;
        this._pushNotificationService = pushNotificationService;
        this._openIdLoginConfiguration = openIdLoginConfiguration;
    }

    @Override
    public void logoutFromMobileDevices(PersonId personId) {
        this._oAuthTokenService.deleteAccessTokensByPersonIdWithClientId(personId, this.getAllMobileClientIds());
        this._pushNotificationService.removePushTargetAppsOfPersonIds((Set<PersonId>)ImmutableSet.of((Object)personId));
    }

    @Override
    public long countMobileLogins(PersonId personId) {
        return this._oAuthTokenService.countAccessTokensByPersonIdWithClientId(personId, this.getAllMobileClientIds());
    }

    @Nonnull
    private Set<OAuthClientId> getAllMobileClientIds() {
        String mobileLoginClient = this._openIdLoginConfiguration.getOpenIdLoginMobileClientId();
        if (mobileLoginClient == null) {
            return Set.of(OLD_MOBILE_CLIENT);
        }
        return Set.of(OLD_MOBILE_CLIENT, new OAuthClientId(mobileLoginClient));
    }
}

