/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import com.google.common.base.Strings;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.person.business.PersonReadDataService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.LoginException;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.security.service.AuthenticationExceptionErrorCodeMapper;
import de.justsoftware.onx.security.service.JustConnectAuthenticationService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.stereotype.Service;

@Service(value="authenticationService")
@ParametersAreNonnullByDefault
public class JustConnectAuthenticationServiceImpl
implements JustConnectAuthenticationService {
    private static final Logger LOG = LoggerFactory.getLogger(JustConnectAuthenticationServiceImpl.class);
    private final AuthenticationManager _authenticationManager;
    private final UserDetailsChecker _userValidator;
    private final AuthenticationExceptionErrorCodeMapper _errorMapper;
    private final PersonReadDataService _personReadDataService;

    @Autowired
    public JustConnectAuthenticationServiceImpl(@Qualifier(value="authenticationManager") AuthenticationManager authenticationManager, UserDetailsChecker userValidator, AuthenticationExceptionErrorCodeMapper errorMapper, PersonReadDataService personReadDataService) {
        this._authenticationManager = authenticationManager;
        this._userValidator = userValidator;
        this._errorMapper = errorMapper;
        this._personReadDataService = personReadDataService;
    }

    @Override
    public DBPerson authenticate(String username, String password) throws LoginException {
        DBPerson existingPerson = this._personReadDataService.getPersonById(this.authenticateToPersonId(username, password));
        if (existingPerson == null) {
            throw new LoginException(LoginException.LoginErrorCode.ACCOUNT_NOT_ACTIVE);
        }
        return existingPerson;
    }

    private PersonId authenticateToPersonId(String username, String password) throws LoginException {
        return SecurityUtils.getUserId(this.authenticateToUser(username, password));
    }

    private JustConnectUser authenticateToUser(String username, String password) throws LoginException {
        try {
            Authentication authentication = this._authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)JustConnectAuthenticationServiceImpl.trimmedNotNull(username), (Object)JustConnectAuthenticationServiceImpl.trimmedNotNull(password)));
            return this.checkForValidUser(authentication);
        }
        catch (AuthenticationException ae) {
            LOG.info("authentication for username " + username + " failed! ", (Throwable)ae);
            LoginException.LoginErrorCode errorCode = this._errorMapper.getErrorCode(ae);
            throw new LoginException(errorCode);
        }
    }

    @Nonnull
    private JustConnectUser checkForValidUser(Authentication authentication) throws LoginException {
        JustConnectUser user = SecurityUtils.getJustConnectUser(authentication);
        if (user == null) {
            LOG.error("Unexpected principal found in authentication {}! Please make sure security is setup to return a JustConnectUser as principal!", (Object)authentication);
            throw new LoginException(LoginException.LoginErrorCode.BAD_PASSWORD_OR_USERNAME);
        }
        try {
            this._userValidator.check((UserDetails)user);
        }
        catch (AuthenticationException ae) {
            LOG.info("authentication for username " + user.getUsername() + " failed! ", (Throwable)ae);
            LoginException.LoginErrorCode errorCode = this._errorMapper.getErrorCode(ae);
            throw new LoginException(errorCode);
        }
        return user;
    }

    @Nonnull
    private static String trimmedNotNull(@Nullable String s) {
        return Strings.nullToEmpty((String)s).trim();
    }
}

