/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.security.service.HasAuthenticationProvider;
import de.justsoftware.onx.security.service.JustAuthenticationProvider;
import de.justsoftware.onx.security.service.impl.AuthenticationFailureCounter;
import de.justsoftware.onx.security.service.impl.JustAuthenticationDetails;
import de.justsoftware.onx.security.trusteddevice.business.TrustedDeviceService;
import java.security.Principal;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.CredentialsContainer;

@ParametersAreNonnullByDefault
public class JustConnectAuthenticationManager
implements AuthenticationManager,
HasAuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AUTHENTICATIONLOG");
    private static final ConcurrentHashMap<String, AuthenticationProvider> FAST_ACCESS_MAP = new ConcurrentHashMap();
    private final ImmutableList<AuthenticationProvider> _extraProviders;
    private ImmutableList<JustAuthenticationProvider> _internalProviders = ImmutableList.of();
    private AuthenticationEventPublisher _eventPublisher = new LoggingEventPublisher();
    private boolean _cacheSucceeding;
    private AuthenticationFailureCounter _authenticationFailureCounter;
    private TrustedDeviceService _trustedDeviceService;

    public JustConnectAuthenticationManager(Iterable<AuthenticationProvider> providers) {
        this._extraProviders = FluentIterable.from(providers).filter(Predicates.notNull()).toList();
        if (this._extraProviders.isEmpty()) {
            throw new IllegalStateException("provider list can't be empty, please provide at least one provider!");
        }
        this.setCacheSucceeding(this._extraProviders.size() > 1);
    }

    public JustConnectAuthenticationManager(AuthenticationProvider provider) {
        this((Iterable<AuthenticationProvider>)ImmutableList.of((Object)provider));
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        AuthenticationException lastException = null;
        this.checkAuthentication(authentication);
        for (AuthenticationProvider provider : this.getOrderedProviders(authentication)) {
            if (!provider.supports(authentication.getClass())) continue;
            LOGGER.debug("Authentication attempt using " + provider.getClass().getName());
            try {
                Authentication result = provider.authenticate(authentication);
                if (result == null) continue;
                return this.authenticationSucceeded(result, authentication, provider);
            }
            catch (AccountStatusException e) {
                LOGGER.debug("Authentication failed for principal " + authentication.getName(), (Throwable)e);
                throw this.authenticationFailed((AuthenticationException)((Object)e), authentication);
            }
            catch (InternalAuthenticationServiceException e) {
                LOGGER.debug("Authentication failed for principal " + authentication.getName(), (Throwable)e);
                lastException = (AuthenticationException)((Object)MoreObjects.firstNonNull((Object)((Object)lastException), (Object)((Object)e)));
            }
            catch (AuthenticationException e) {
                LOGGER.debug("Authentication failed for principal " + authentication.getName(), (Throwable)e);
                lastException = e;
            }
            catch (RuntimeException e) {
                LOGGER.debug("Authentication failed for principal " + authentication.getName(), (Throwable)e);
                lastException = (AuthenticationException)((Object)MoreObjects.firstNonNull((Object)((Object)lastException), (Object)((Object)new InternalAuthenticationServiceException("Wrapped unexpected runtime exception", (Throwable)e))));
            }
        }
        throw this.authenticationFailed(lastException, authentication);
    }

    private void checkAuthentication(@Nullable Authentication authentication) {
        if (authentication == null) {
            LOGGER.debug("Authentication failed: can't authenticate null authentication");
            throw new InternalAuthenticationServiceException("can't authenticate null authentication");
        }
        if (authentication.getClass().equals(UsernamePasswordAuthenticationToken.class) && StringUtil.isBlank(authentication.getName())) {
            LOGGER.debug("Authentication failed: can't authenticate empty user");
            throw this.authenticationFailed((AuthenticationException)((Object)new InternalAuthenticationServiceException("can't authenticate empty user")), authentication);
        }
        if (authentication instanceof UsernamePasswordAuthenticationToken && authentication.getDetails() instanceof JustAuthenticationDetails) {
            boolean accountMayLogIn = this._trustedDeviceService.accountMayLogIn(authentication.getName(), ((JustAuthenticationDetails)authentication.getDetails()).getTrustedDeviceCookie());
            if (!accountMayLogIn) {
                throw this.authenticationFailed((AuthenticationException)new LockedException("user " + authentication.getName() + " is blocked by trusted device service."), authentication);
            }
            ((UsernamePasswordAuthenticationToken)authentication).setDetails(null);
        }
    }

    @Nonnull
    private Iterable<AuthenticationProvider> getOrderedProviders(Authentication authentication) {
        if (!this.isCacheSucceeding() || !(authentication instanceof UsernamePasswordAuthenticationToken)) {
            return this.getProviders();
        }
        AuthenticationProvider lastProvider = FAST_ACCESS_MAP.get(this.getCacheKeyName(authentication));
        return lastProvider == null ? this.getProviders() : FluentIterable.of((Object)lastProvider, (Object[])new AuthenticationProvider[0]).append((Iterable)this.getProviders().filter(input -> input != lastProvider));
    }

    @Nonnull
    private Authentication authenticationSucceeded(Authentication result, Authentication authentication, AuthenticationProvider provider) {
        if (result instanceof AbstractAuthenticationToken && result.getDetails() == null) {
            ((AbstractAuthenticationToken)AbstractAuthenticationToken.class.cast(result)).setDetails(authentication.getDetails());
        }
        if (result instanceof CredentialsContainer) {
            ((CredentialsContainer)CredentialsContainer.class.cast(result)).eraseCredentials();
        }
        if (this.isCacheSucceeding() && UsernamePasswordAuthenticationToken.class.isInstance(authentication)) {
            FAST_ACCESS_MAP.put(this.getCacheKeyName(result), provider);
        }
        return result;
    }

    @Nonnull
    private String getCacheKeyName(Authentication authentication) {
        return authentication.getClass().getName() + ":" + authentication.getName();
    }

    @Nonnull
    private AuthenticationException authenticationFailed(@Nullable AuthenticationException lastException, Authentication authentication) {
        AuthenticationException result = lastException != null ? lastException : new ProviderNotFoundException("No AuthenticationProvider found for " + authentication.getClass().getName());
        this._eventPublisher.publishAuthenticationFailure(result, authentication);
        if (lastException instanceof BadCredentialsException) {
            this._authenticationFailureCounter.countFailedAuthentication((Principal)authentication);
        }
        return result;
    }

    @Nonnull
    public AuthenticationEventPublisher getAuthenticationEventPublisher() {
        return this._eventPublisher;
    }

    public void setAuthenticationEventPublisher(@Nullable AuthenticationEventPublisher eventPublisher) {
        if (eventPublisher != null) {
            this._eventPublisher = eventPublisher;
        } else {
            LOGGER.error("AuthenticationEventPublisher cannot be null");
        }
    }

    @Autowired
    public void setAuthenticationFailureCounter(AuthenticationFailureCounter attemptCounter) {
        this._authenticationFailureCounter = attemptCounter;
    }

    @Autowired
    public void setTrustedDeviceService(TrustedDeviceService trustedDeviceService) {
        this._trustedDeviceService = trustedDeviceService;
    }

    public void setCacheSucceeding(boolean cacheSucceeding) {
        FAST_ACCESS_MAP.clear();
        this._cacheSucceeding = cacheSucceeding;
    }

    public boolean isCacheSucceeding() {
        return this._cacheSucceeding;
    }

    @Autowired(required=false)
    public void setInternalProviders(Collection<JustAuthenticationProvider> providers) {
        this._internalProviders = ImmutableList.copyOf(providers);
    }

    public FluentIterable<AuthenticationProvider> getProviders() {
        return FluentIterable.from(this._extraProviders).append(this._internalProviders);
    }

    @ParametersAreNonnullByDefault
    private static final class LoggingEventPublisher
    implements AuthenticationEventPublisher {
        private static final Joiner JOINER = Joiner.on((char)' ').skipNulls();
        private static final String PREFIX = "authentication with token";
        private static final String WITH = "with principal:";
        private static final String WITHOUT = "without principal";
        private static final String FAIL_SUFFIX = "failed. {}";
        private static final String OK_SUFFIX = "succeeded";

        private LoggingEventPublisher() {
        }

        @Nonnull
        private String toMessage(Authentication authentication, @Nullable AuthenticationException exception) {
            String name = authentication.getName();
            String mid = StringUtil.isBlank(name) ? WITHOUT : JOINER.join((Object)WITH, (Object)name, new Object[0]);
            String suffix = exception == null ? OK_SUFFIX : FAIL_SUFFIX;
            return JOINER.join((Object)PREFIX, (Object)mid, new Object[]{suffix});
        }

        public void publishAuthenticationFailure(AuthenticationException exception, Authentication authentication) {
            String failureCause = exception == null ? "" : "Cause: " + ((Object)((Object)exception)).getClass().getName();
            LOGGER.info(this.toMessage(authentication, exception), (Object)failureCause);
        }

        public void publishAuthenticationSuccess(Authentication authentication) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.toMessage(authentication, null));
            }
        }
    }
}

