/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import de.justsoftware.onx.security.service.JucoPasswordEncoder;
import de.justsoftware.onx.security.service.impl.Passwords;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import org.bouncycastle.crypto.generators.OpenBSDBCrypt;
import org.springframework.stereotype.Service;

@Service(value="passwordEncoder")
public class JucoPasswordEncoderImpl
implements JucoPasswordEncoder {
    public static final String MD5_BCRYPT_PREFIX = "$md5bcrypt$";
    public static final String BCRYPT_PREFIX = "$2";

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if (encodedPassword == null || rawPassword == null) {
            return false;
        }
        if (encodedPassword.startsWith(BCRYPT_PREFIX)) {
            return OpenBSDBCrypt.checkPassword((String)encodedPassword, (char[])rawPassword.toString().toCharArray());
        }
        if (encodedPassword.startsWith(MD5_BCRYPT_PREFIX)) {
            return this.matchesMd5Bcrypt(rawPassword, encodedPassword.substring(MD5_BCRYPT_PREFIX.length()));
        }
        return Passwords.verifyPassword(rawPassword.toString(), encodedPassword);
    }

    public String encode(CharSequence rawPassword) {
        byte[] salt = SecureRandomUtil.randomBytes(16);
        return OpenBSDBCrypt.generate((String)"2b", (char[])rawPassword.toString().toCharArray(), (byte[])salt, (int)12);
    }

    private boolean matchesMd5Bcrypt(CharSequence rawPassword, String hashedPasswordWithoutPrefix) {
        int dollar = hashedPasswordWithoutPrefix.indexOf(36);
        if (dollar < 0) {
            return false;
        }
        String bcrypt = hashedPasswordWithoutPrefix.substring(dollar);
        String salt = hashedPasswordWithoutPrefix.substring(0, dollar);
        String md5 = Passwords.hashPassword(rawPassword.toString(), salt);
        return this.matches(md5, bcrypt);
    }

    public boolean upgradeEncoding(String encodedPassword) {
        return encodedPassword == null || !encodedPassword.startsWith(BCRYPT_PREFIX);
    }

    @Override
    public String hashMd5Password(String oldHashedPassword) {
        String[] saltAndHash = oldHashedPassword.split("\\$");
        if (saltAndHash.length < 2) {
            throw new IllegalStateException("md5 hashed password does not contain $");
        }
        String salt = saltAndHash[0];
        return MD5_BCRYPT_PREFIX + salt + this.encode(oldHashedPassword);
    }
}

