/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.service.impl;

import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.trusteddevice.business.TrustedDeviceService;
import java.security.Principal;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class AuthenticationFailureCounter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFailureCounter.class);
    private final PersonService _personService;
    private final TrustedDeviceService _trustedDeviceService;

    @Autowired
    public AuthenticationFailureCounter(PersonService personService, TrustedDeviceService trustedDeviceService) {
        this._personService = personService;
        this._trustedDeviceService = trustedDeviceService;
    }

    public void countFailedAuthentication(Principal attemptingUser) {
        String loginEmail = attemptingUser.getName();
        DBPerson person = this._personService.getPersonByEmail(loginEmail);
        if (person == null) {
            LOG.debug("Could not find person entry for user attempting log-in: {}", (Object)loginEmail);
        } else {
            this._trustedDeviceService.handleFailedLoginAttempt(person.getId().asProfileId());
        }
    }
}

