/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.rememberme.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@ParametersAreNonnullByDefault
public class JustConnectDelegatingRememberMeService
implements RememberMeServices,
LogoutHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JustConnectDelegatingRememberMeService.class);
    private final ImmutableList<RememberMeServices> _rememberMeServices;
    private final ImmutableList<LogoutHandler> _logoutHandlers;
    private RequestMatcher _requestMatcher = AnyRequestMatcher.INSTANCE;

    @Autowired
    @ParametersAreNonnullByDefault
    public JustConnectDelegatingRememberMeService(Iterable<RememberMeServices> allRememberMeServices) {
        this._rememberMeServices = ImmutableList.copyOf(allRememberMeServices);
        this._logoutHandlers = ImmutableList.copyOf((Iterable)Iterables.filter(allRememberMeServices, LogoutHandler.class));
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        LOG.debug("logout");
        for (LogoutHandler handler : this._logoutHandlers) {
            try {
                handler.logout(request, response, authentication);
            }
            catch (RuntimeException e) {
                LOG.error("logout failed for handler: " + handler.getClass().getCanonicalName(), (Throwable)e);
            }
        }
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        if (!this._requestMatcher.matches(request)) {
            return null;
        }
        for (RememberMeServices handler : this._rememberMeServices) {
            try {
                Authentication autoLogin = handler.autoLogin(request, response);
                if (autoLogin == null) continue;
                return autoLogin;
            }
            catch (RuntimeException e) {
                LOG.error("autoLogin failed for handler: " + handler.getClass().getCanonicalName(), (Throwable)e);
            }
        }
        return null;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        for (RememberMeServices handler : this._rememberMeServices) {
            try {
                handler.loginFail(request, response);
            }
            catch (RuntimeException e) {
                LOG.error("loginFail failed for handler: " + handler.getClass().getCanonicalName(), (Throwable)e);
            }
        }
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        for (RememberMeServices handler : this._rememberMeServices) {
            try {
                handler.loginSuccess(request, response, successfulAuthentication);
            }
            catch (RuntimeException e) {
                LOG.error("loginSuccess failed for handler: " + handler.getClass().getCanonicalName(), (Throwable)e);
            }
        }
    }

    public void setRequestMatcher(RequestMatcher requestMatcher) {
        this._requestMatcher = requestMatcher;
    }
}

