/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.rememberme.impl;

import com.google.common.base.Charsets;
import de.justsoftware.onx.common.shared.server.util.CookieUtil;
import de.justsoftware.onx.secret.business.HMacSecretKey;
import de.justsoftware.onx.secret.business.SecretKeyName;
import de.justsoftware.onx.secret.business.SecretService;
import de.justsoftware.onx.util.server.Base64Util;
import de.justsoftware.onx.util.server.HMacUtil;
import java.nio.ByteBuffer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.TokenBasedRememberMeServices;
import org.springframework.stereotype.Service;

@Service(value="rememberMeServices")
public class JucoRememberMeService
extends TokenBasedRememberMeServices {
    static final String KEY = "juco";
    private final SecretService _secretService;

    @Autowired
    @ParametersAreNonnullByDefault
    public JucoRememberMeService(UserDetailsService userDetailsService, SecretService secretService) {
        super(KEY, userDetailsService);
        this._secretService = secretService;
        this.setCookieName("rememberMe");
        this.setTokenValiditySeconds(CookieUtil.LONG_LASTING_COOKIE_LIFETIME_SECONDS);
        this.setParameter("remember");
    }

    protected String makeTokenSignature(long tokenExpiryTime, String username, String password) {
        HMacSecretKey secret = (HMacSecretKey)this._secretService.getSecretKey(SecretKeyName.REMEMBER_ME_COOKIE_SECRET);
        byte[] usernameBytes = username.getBytes(Charsets.UTF_8);
        byte[] passwordBytes = password.getBytes(Charsets.UTF_8);
        byte[] signatureData = ByteBuffer.allocate(8 + passwordBytes.length + usernameBytes.length).putLong(tokenExpiryTime).put(passwordBytes).put(usernameBytes).array();
        return Base64Util.encode(HMacUtil.computeHMac(HMacUtil.HMacType.HMAC_SHA512, signatureData, secret));
    }
}

