/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.integration.persistence.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAccessTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthRefreshTokenId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class DBOAuthToken
implements Serializable {
    public static final Function<DBOAuthToken, OAuthAccessTokenId> TO_ACCESS_TOKEN_ID = new NullPermeableFunction<DBOAuthToken, OAuthAccessTokenId>(){

        @Override
        protected OAuthAccessTokenId applySafe(DBOAuthToken token) {
            return token.getAccessToken();
        }
    };
    private static final long serialVersionUID = 1L;
    private OAuthAccessTokenId _accessToken;
    private DateTime _accessTokenExpiry;
    private OAuthRefreshTokenId _refreshToken;
    private DateTime _refreshTokenExpiry;
    private OAuthClientId _clientId;
    private String _scope;
    private String _grantType;
    private PersonId _personId;

    @Deprecated
    protected DBOAuthToken() {
    }

    public DBOAuthToken(OAuthAccessTokenId accessToken, DateTime accessTokenExpiry, @Nullable OAuthRefreshTokenId refreshToken, @Nullable DateTime refreshTokenExpiry, OAuthClientId clientId, String scope, String grantType, @Nullable PersonId personId) {
        this._accessToken = accessToken;
        this._accessTokenExpiry = accessTokenExpiry;
        this._refreshToken = refreshToken;
        this._refreshTokenExpiry = refreshTokenExpiry;
        this._clientId = clientId;
        this._scope = scope;
        this._grantType = grantType;
        this._personId = personId;
    }

    @Nonnull
    public OAuthAccessTokenId getAccessToken() {
        return this._accessToken;
    }

    public void setAccessToken(OAuthAccessTokenId accessToken) {
        this._accessToken = accessToken;
    }

    @Nonnull
    public DateTime getAccessTokenExpiry() {
        return this._accessTokenExpiry;
    }

    public void setAccessTokenExpiry(DateTime accessTokenExpiry) {
        this._accessTokenExpiry = accessTokenExpiry;
    }

    @CheckForNull
    public OAuthRefreshTokenId getRefreshToken() {
        return this._refreshToken;
    }

    public void setRefreshToken(@Nullable OAuthRefreshTokenId refreshToken) {
        this._refreshToken = refreshToken;
    }

    @CheckForNull
    public DateTime getRefreshTokenExpiry() {
        return this._refreshTokenExpiry;
    }

    public void setRefreshTokenExpiry(@Nullable DateTime refreshTokenExpiry) {
        this._refreshTokenExpiry = refreshTokenExpiry;
    }

    @Nonnull
    public OAuthClientId getClientId() {
        return this._clientId;
    }

    public void setClientId(OAuthClientId clientId) {
        this._clientId = clientId;
    }

    @Nonnull
    public String getScope() {
        return this._scope;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    @Nonnull
    public String getGrantType() {
        return this._grantType;
    }

    public void setGrantType(String grantType) {
        this._grantType = grantType;
    }

    @CheckForNull
    public PersonId getPersonId() {
        return this._personId;
    }

    public void setPersonId(@Nullable PersonId personId) {
        this._personId = personId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._accessToken, this._accessTokenExpiry, this._refreshToken, this._refreshTokenExpiry, this._clientId, this._scope, this._grantType, this._personId});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof DBOAuthToken && this.equalInstance((DBOAuthToken)obj);
    }

    private boolean equalInstance(DBOAuthToken obj) {
        return Objects.equal((Object)this._accessToken, (Object)obj._accessToken) && Objects.equal((Object)this._accessTokenExpiry, (Object)obj._accessTokenExpiry) && Objects.equal((Object)this._refreshToken, (Object)obj._refreshToken) && Objects.equal((Object)this._refreshTokenExpiry, (Object)obj._refreshTokenExpiry) && Objects.equal((Object)this._clientId, (Object)obj._clientId) && Objects.equal((Object)this._scope, (Object)obj._scope) && Objects.equal((Object)this._grantType, (Object)obj._grantType) && Objects.equal((Object)this._personId, (Object)obj._personId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accessToken", (Object)this._accessToken).add("accessTokenExpiry", (Object)this._accessTokenExpiry).add("refreshToken", (Object)this._refreshToken).add("refreshTokenExpiry", (Object)this._refreshTokenExpiry).add("clientId", (Object)this._clientId).add("scope", (Object)this._scope).add("grantType", (Object)this._grantType).add("personId", (Object)this._personId).toString();
    }
}

