/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.integration.persistence.ibatis;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.integration.persistence.DAOException;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAccessTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthRefreshTokenId;
import de.justsoftware.onx.security.oauth.integration.persistence.OAuthTokenDAO;
import de.justsoftware.onx.security.oauth.integration.persistence.model.DBOAuthToken;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ibatisOAuthTokenDAO")
@ParametersAreNonnullByDefault
public class IbatisOAuthTokenDAO
implements OAuthTokenDAO {
    private static final Logger LOG = LoggerFactory.getLogger(IbatisOAuthTokenDAO.class);
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisOAuthTokenDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("OAuthToken");
    }

    @Override
    public int createToken(OAuthAccessTokenId accessToken, DateTime accessTokenExpiry, OAuthRefreshTokenId refreshToken, DateTime refreshTokenExpiry, OAuthClientId clientId, String scope, String grantType, PersonId personId) {
        ImmutableMap.Builder nonNullMap = ImmutableMap.builder().put((Object)"accessToken", (Object)accessToken).put((Object)"accessTokenExpiry", (Object)accessTokenExpiry).put((Object)"clientId", (Object)clientId).put((Object)"scope", (Object)scope).put((Object)"grantType", (Object)grantType);
        if (refreshToken != null) {
            nonNullMap.put((Object)"refreshToken", (Object)refreshToken);
        }
        if (refreshTokenExpiry != null) {
            nonNullMap.put((Object)"refreshTokenExpiry", (Object)refreshTokenExpiry);
        }
        if (personId != null) {
            nonNullMap.put((Object)"personId", (Object)personId);
        }
        try {
            this._statementBuilder.insert("insertToken").param(nonNullMap.build()).orNull();
            return 1;
        }
        catch (DAOException e) {
            LOG.error("error inserting oauth token {} : {}", (Object)clientId, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int deleteToken(Set<OAuthAccessTokenId> accessTokenIds) {
        try {
            return (Integer)this._statementBuilder.delete("deleteToken").partition(accessTokenIds);
        }
        catch (DAOException e) {
            LOG.error("error deleting oauth tokens {} : {}", accessTokenIds, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public int deleteTokenByClientIds(Set<OAuthClientId> clientIds) {
        try {
            return (Integer)this._statementBuilder.delete("deleteTokenByClient").partition(clientIds);
        }
        catch (DAOException e) {
            LOG.error("error deleting oauth tokens for clients {} : {}", clientIds, (Object)e.getMessage());
            return 0;
        }
    }

    @Override
    public ImmutableMap<OAuthAccessTokenId, DBOAuthToken> getTokensByAccessTokenId(Set<OAuthAccessTokenId> accessTokenIds) {
        try {
            return ((IbatisPartitionResultBuilder)this._statementBuilder.select("selectTokenByAccessToken").partition(accessTokenIds)).asMap("accessToken", null);
        }
        catch (DAOException e) {
            LOG.error("error fetching oauth tokens by access token {} : {}", accessTokenIds, (Object)e.getMessage());
            return ImmutableMap.of();
        }
    }

    @Override
    public ImmutableMap<OAuthRefreshTokenId, DBOAuthToken> getTokensByRefreshTokenId(Set<OAuthRefreshTokenId> refreshTokenIds) {
        try {
            return ((IbatisPartitionResultBuilder)this._statementBuilder.select("selectTokenByRefreshToken").partition(refreshTokenIds)).asMap("refreshToken", null);
        }
        catch (DAOException e) {
            LOG.error("error fetching oauth tokens by refresh token {} : {}", refreshTokenIds, (Object)e.getMessage());
            return ImmutableMap.of();
        }
    }

    @Override
    public ImmutableListMultimap<PersonId, DBOAuthToken> getTokensByPersonId(Set<PersonId> personIds) {
        try {
            return ((IbatisPartitionResultBuilder)this._statementBuilder.select("selectTokenByPerson").partition(personIds)).asListMultimap("personId", null);
        }
        catch (DAOException e) {
            LOG.error("error fetching oauth token ids by person ids {} : {}", personIds, (Object)e.getMessage());
            return ImmutableListMultimap.of();
        }
    }

    @Override
    public void deleteExpiredAccessTokens(DateTime now) {
        try {
            this._statementBuilder.delete("deleteExpiredTokens").param("now", new DateWithoutTimezone(now.toDate()));
        }
        catch (DAOException e) {
            LOG.error("Could not delete expired access tokens. {}", (Object)e.getMessage());
        }
    }

    @Override
    public int updateTokenExpiry(OAuthAccessTokenId accessTokenId, DateTime accessTokenExpiry, DateTime refreshTokenExpiry) {
        return (Integer)this._statementBuilder.update("updateTokenExpiry").param("accessToken", accessTokenId, "accessTokenExpiry", new DateWithoutTimezone(accessTokenExpiry.toDate()), "refreshTokenExpiry", new DateWithoutTimezone(refreshTokenExpiry.toDate()));
    }
}

