/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.server.model;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.core.GrantedAuthority;

@ParametersAreNonnullByDefault
public final class OAuthAuthority
implements GrantedAuthority {
    public static final Function<GrantedAuthority, OAuthAuthority> FROM_GRANTED_AUTHORITY = new NullPermeableFunction<GrantedAuthority, OAuthAuthority>(){

        @Override
        protected OAuthAuthority applySafe(GrantedAuthority input) {
            return new OAuthAuthority(input);
        }
    };
    public static final Function<String, OAuthAuthority> FROM_STRING = new NullPermeableFunction<String, OAuthAuthority>(){

        @Override
        protected OAuthAuthority applySafe(String input) {
            return new OAuthAuthority(input);
        }
    };
    private static final long serialVersionUID = 1L;
    private final String _authority;

    public OAuthAuthority(String authority) {
        this._authority = authority;
    }

    public OAuthAuthority(GrantedAuthority authority) {
        this(authority.getAuthority());
    }

    public String getAuthority() {
        return this._authority;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._authority});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof OAuthAuthority && Objects.equal((Object)this._authority, (Object)((OAuthAuthority)obj)._authority);
    }

    public String toString() {
        return this.getAuthority();
    }
}

