/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.ClientRegistrationException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.stereotype.Service;

@Service(value="userApprovalHandler")
@ParametersAreNonnullByDefault
public class TokenServicesUserApprovalHandler
implements UserApprovalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TokenServicesUserApprovalHandler.class);
    private final AuthorizationServerTokenServices _tokenServices;
    private final ClientDetailsService _clientDetailsService;

    @Autowired
    public TokenServicesUserApprovalHandler(AuthorizationServerTokenServices tokenServices, ClientDetailsService clientDetailsService) {
        this._tokenServices = tokenServices;
        this._clientDetailsService = clientDetailsService;
    }

    public boolean isApproved(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        return authorizationRequest.isApproved();
    }

    public AuthorizationRequest checkForPreApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        boolean autoApprovingClient = this.checkForAutoApprovingClient(authorizationRequest);
        if (autoApprovingClient) {
            authorizationRequest.setApproved(true);
            return authorizationRequest;
        }
        boolean accessTokenExistsAndIsNotExpired = this.checkForExistingAccessToken(authorizationRequest, userAuthentication);
        boolean isUserAuthenticated = this.checkForUserAuthentication(userAuthentication);
        authorizationRequest.setApproved(accessTokenExistsAndIsNotExpired && isUserAuthenticated);
        return authorizationRequest;
    }

    private boolean checkForUserAuthentication(@Nullable Authentication userAuthentication) {
        return userAuthentication != null && userAuthentication.isAuthenticated();
    }

    private boolean checkForExistingAccessToken(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        OAuth2AccessToken accessToken = this._tokenServices.getAccessToken(new OAuth2Authentication(authorizationRequest.createOAuth2Request(), userAuthentication));
        return accessToken != null && !accessToken.isExpired();
    }

    private boolean checkForAutoApprovingClient(AuthorizationRequest authorizationRequest) {
        ClientDetails client = this.loadClientOptional(authorizationRequest.getClientId());
        return FluentIterable.from((Iterable)authorizationRequest.getScope()).allMatch((Predicate)new IsAutoApprovingScope(client));
    }

    @CheckForNull
    private ClientDetails loadClientOptional(@Nullable String clientId) {
        if (clientId == null) {
            return null;
        }
        try {
            return this._clientDetailsService.loadClientByClientId(clientId);
        }
        catch (ClientRegistrationException e) {
            LOG.warn("Client registration problem prevents autoapproval check for client={}", (Object)clientId, (Object)e);
            return null;
        }
    }

    public AuthorizationRequest updateAfterApproval(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        Map approvalParameters = authorizationRequest.getApprovalParameters();
        String flag = (String)approvalParameters.get("user_oauth_approval");
        boolean approved = flag != null && flag.toLowerCase().equals("true");
        authorizationRequest.setApproved(approved);
        return authorizationRequest;
    }

    public Map<String, Object> getUserApprovalRequest(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(authorizationRequest.getRequestParameters());
        return model;
    }

    private static final class IsAutoApprovingScope
    implements Predicate<String> {
        private final ClientDetails _client;

        private IsAutoApprovingScope(@Nullable ClientDetails client) {
            this._client = client;
        }

        public boolean apply(String scope) {
            return this._client != null && scope != null && this._client.isAutoApprove(scope);
        }
    }
}

