/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.oauth.business.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.person.business.PersonReadDataService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.model.JustConnectUser;
import de.justsoftware.onx.security.model.JustConnectUserAuthenticationToken;
import de.justsoftware.onx.security.oauth.business.OAuthClientReadDataService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenReadDataService;
import de.justsoftware.onx.security.oauth.business.OAuthTokenWriteDataService;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthAccessTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClient;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthClientId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthRefreshTokenId;
import de.justsoftware.onx.security.oauth.business.server.model.OAuthToken;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidClientException;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;
import org.springframework.security.oauth2.common.exceptions.InvalidRequestException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.common.util.OAuth2Utils;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.stereotype.Service;

@Service(value="tokenServices")
@ParametersAreNonnullByDefault
public class SpringOAuthTokenServiceImpl
implements AuthorizationServerTokenServices,
ResourceServerTokenServices,
ConsumerTokenServices {
    private static final Logger LOG = LoggerFactory.getLogger(SpringOAuthTokenServiceImpl.class);
    private static final long DEFAULT_ACCESS_TOKEN_VALIDITY_SECONDS = TimeUnit.HOURS.toSeconds(12L);
    private static final long DEFAULT_REFRESH_TOKEN_VALIDITY_SECONDS = TimeUnit.DAYS.toSeconds(30L);
    private final UserDetailsChecker _userDetailsChecker = new AccountStatusUserDetailsChecker();
    private final Clock _clock;
    private final OAuthTokenReadDataService _tokenReadDataService;
    private final OAuthTokenWriteDataService _tokenWriteDataService;
    private final OAuthClientReadDataService _clientReadDataService;
    private final PersonReadDataService _personReadDataService;
    private final TransactionHelper _transactionHelper;
    private final AuthorizationContextProvider _authorizationContextProvider;

    @Autowired
    public SpringOAuthTokenServiceImpl(Clock clock, OAuthTokenReadDataService tokenReadDataService, OAuthTokenWriteDataService tokenWriteDataService, OAuthClientReadDataService clientReadDataService, PersonReadDataService personReadDataService, TransactionHelper transactionHelper, AuthorizationContextProvider authorizationContextProvider) {
        this._clock = clock;
        this._tokenReadDataService = tokenReadDataService;
        this._tokenWriteDataService = tokenWriteDataService;
        this._clientReadDataService = clientReadDataService;
        this._personReadDataService = personReadDataService;
        this._transactionHelper = transactionHelper;
        this._authorizationContextProvider = authorizationContextProvider;
    }

    @Nonnull
    private DateTime getAccessTokenExpiry(OAuthClient client) {
        return this.getTokenExpiry(client.getAccessTokenValiditySeconds(), DEFAULT_ACCESS_TOKEN_VALIDITY_SECONDS);
    }

    @Nonnull
    private DateTime getRefreshTokenExpiry(OAuthClient client) {
        return this.getTokenExpiry(client.getRefreshTokenValiditySeconds(), DEFAULT_REFRESH_TOKEN_VALIDITY_SECONDS);
    }

    @Nonnull
    private DateTime getTokenExpiry(@Nullable Integer clientExpirySeconds, long defaultExpirySeconds) {
        return this._clock.now().plusSeconds(clientExpirySeconds != null && clientExpirySeconds > 0 ? clientExpirySeconds.intValue() : Long.valueOf(defaultExpirySeconds).intValue()).plusMinutes(1).withSecondOfMinute(0);
    }

    private boolean isSupportRefreshToken(OAuthClient client) {
        return client.getAuthorizedGrantTypes().contains("refresh_token");
    }

    @CheckForNull
    private OAuth2AuthenticationDetails getAuthenticationDetails(OAuth2Authentication authentication) {
        Object details = authentication.getDetails();
        return OAuth2AuthenticationDetails.class.isInstance(details) ? (OAuth2AuthenticationDetails)OAuth2AuthenticationDetails.class.cast(details) : null;
    }

    @CheckForNull
    private OAuthAccessTokenId getAccessTokenId(OAuth2Authentication authentication) {
        String tokenValue;
        OAuth2AuthenticationDetails details = this.getAuthenticationDetails(authentication);
        if (details != null && (tokenValue = details.getTokenValue()) != null) {
            return this.getAccessTokenId(tokenValue);
        }
        return null;
    }

    @CheckForNull
    private OAuthToken getTokenByAccessTokenId(@Nullable OAuthAccessTokenId id) {
        return id != null ? this._tokenReadDataService.getTokenByAccessTokenId(id) : null;
    }

    private boolean isExpired(@Nullable DateTime expiry) {
        return expiry != null && this._clock.now().isAfter((ReadableInstant)expiry);
    }

    @Nonnull
    private String createNewTokenId() {
        return UUID.randomUUID().toString();
    }

    @Nonnull
    private OAuthAccessTokenId getAccessTokenId(@Nullable String tokenValue) {
        return OAuthAccessTokenId.of(tokenValue);
    }

    @Nonnull
    private OAuthRefreshTokenId getRefreshTokenId(@Nullable String tokenValue) {
        return OAuthRefreshTokenId.of(tokenValue);
    }

    @CheckForNull
    private OAuth2AccessToken getAccessToken(@Nullable OAuthToken token) {
        return (OAuth2AccessToken)OAuthToken.TO_ACCESS_TOKEN.apply((Object)token);
    }

    @Nonnull
    private OAuthClientId getClientId(@Nullable OAuth2Request request) {
        if (request == null) {
            throw new InvalidRequestException("Request was null!");
        }
        return new OAuthClientId(request.getClientId());
    }

    @Nonnull
    private OAuthClientId getClientId(TokenRequest request) {
        if (request == null) {
            throw new InvalidRequestException("Request was null!");
        }
        return new OAuthClientId(request.getClientId());
    }

    @Nonnull
    private String getGrantType(@Nullable OAuth2Request request) {
        if (request == null) {
            throw new InvalidRequestException("Request was null!");
        }
        String grantType = request.getGrantType();
        if (!StringUtil.isEmpty(grantType)) {
            return grantType;
        }
        throw new InvalidGrantException("Request " + request + " has no grant type specified!");
    }

    @Nonnull
    private OAuthClient getClientById(OAuthClientId clientId) {
        OAuthClient client = this._clientReadDataService.getClientById(clientId);
        if (client == null) {
            throw new InvalidClientException("No client by id " + clientId + " found");
        }
        return client;
    }

    public OAuth2AccessToken createAccessToken(OAuth2Authentication authentication) {
        OAuthToken existingToken = this.getTokenByAccessTokenId(this.getAccessTokenId(authentication));
        OAuthToken token = existingToken == null || this.isExpired(existingToken.getAccessTokenExpiry()) ? this.createToken(authentication, existingToken) : existingToken;
        return this.getAccessToken(token);
    }

    @CheckForNull
    private OAuthToken createToken(OAuth2Authentication authentication, @Nullable OAuthToken existingToken) {
        OAuth2Request request = authentication.getOAuth2Request();
        OAuthClientId clientId = this.getClientId(request);
        String grantType = this.getGrantType(request);
        OAuthClient client = this.getClientById(clientId);
        Set scope = request.narrowScope(client.getScope()).getScope();
        OAuthAccessTokenId accessTokenId = this.getAccessTokenId(this.createNewTokenId());
        DateTime accessTokenExpiry = this.getAccessTokenExpiry(client);
        boolean supportRefreshToken = this.isSupportRefreshToken(client);
        OAuthRefreshTokenId refreshTokenId = supportRefreshToken ? this.getRefreshTokenId(this.createNewTokenId()) : null;
        DateTime refreshTokenExpiry = supportRefreshToken ? this.getRefreshTokenExpiry(client) : null;
        PersonId personId = SecurityUtils.getUserIdOrNull(authentication.getUserAuthentication());
        return this.createAndReplaceToken(accessTokenId, accessTokenExpiry, refreshTokenId, refreshTokenExpiry, clientId, scope, grantType, personId, existingToken);
    }

    public OAuth2AccessToken refreshAccessToken(String refreshTokenValue, TokenRequest tokenRequest) {
        OAuthClientId clientId = this.getClientId(tokenRequest);
        OAuthClient client = this.getClientById(clientId);
        if (!this.isSupportRefreshToken(client)) {
            throw new InvalidGrantException("Client does not support refresh token anymore! Can't use refresh token: " + refreshTokenValue);
        }
        OAuthToken existingToken = this.getValidatedTokenForRefresh(refreshTokenValue, client);
        OAuthAccessTokenId accessTokenId = this.getAccessTokenId(this.createNewTokenId());
        DateTime accessTokenExpiry = this.getAccessTokenExpiry(client);
        OAuthRefreshTokenId refreshTokenId = this.getRefreshTokenId(this.createNewTokenId());
        DateTime refreshTokenExpiry = this.getRefreshTokenExpiry(client);
        Set scope = tokenRequest.createOAuth2Request((ClientDetails)client).narrowScope(existingToken.getScope()).getScope();
        return this.getAccessToken(this.createAndReplaceToken(accessTokenId, accessTokenExpiry, refreshTokenId, refreshTokenExpiry, clientId, scope, existingToken.getGrantType(), existingToken.getPersonId(), existingToken));
    }

    @Nonnull
    private OAuthToken getValidatedTokenForRefresh(String refreshTokenValue, OAuthClient client) {
        OAuthToken tokenFromDb = this._tokenReadDataService.getTokenByRefreshTokenId(this.getRefreshTokenId(refreshTokenValue));
        if (tokenFromDb == null) {
            throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue + " token does not exist!");
        }
        if (this.isExpired(tokenFromDb.getRefreshTokenExpiry())) {
            throw new InvalidTokenException("Invalid refresh token: " + refreshTokenValue + " token is expired " + tokenFromDb.getRefreshTokenExpiry());
        }
        if (!client.getId().equals(tokenFromDb.getClientId())) {
            String errorId = UUID.randomUUID().toString();
            LOG.error(String.format("errorId: %s, Token was issued for other client. token: %s, issuedForClientId: %s, requestedForClient: %s", errorId, refreshTokenValue, client.getId(), tokenFromDb.getClientId()));
            throw new InvalidTokenException("Token was issued for other client. errorId: " + errorId);
        }
        return tokenFromDb;
    }

    @Nonnull
    private OAuthToken createAndReplaceToken(OAuthAccessTokenId accessTokenId, DateTime accessTokenExpiry, @Nullable OAuthRefreshTokenId refreshTokenId, @Nullable DateTime refreshTokenExpiry, OAuthClientId clientId, Set<String> scope, String grantType, @Nullable PersonId personId, @Nullable OAuthToken existingToken) {
        return (OAuthToken)this._transactionHelper.doInTransaction(status -> {
            if (existingToken != null && !this.expireToken(existingToken)) {
                throw new InvalidRequestException("can't expire token : " + existingToken);
            }
            OAuthToken token = this._tokenWriteDataService.createToken(accessTokenId, accessTokenExpiry, refreshTokenId, refreshTokenExpiry, clientId, scope, grantType, personId);
            if (token == null) {
                throw new InvalidRequestException("can't create access token : " + accessTokenId + " for client " + clientId + " and user " + personId);
            }
            return token;
        });
    }

    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        return this.getAccessToken(this.getTokenByAccessTokenId(this.getAccessTokenId(authentication)));
    }

    public OAuth2AccessToken readAccessToken(String value) {
        return this.getAccessToken(this.getTokenByAccessTokenId(this.getAccessTokenId(value)));
    }

    public OAuth2Authentication loadAuthentication(String accessTokenValue) {
        OAuthToken token = this.getTokenByAccessTokenId(this.getAccessTokenId(accessTokenValue));
        if (token == null) {
            throw new InvalidTokenException("Invalid access token: " + accessTokenValue);
        }
        if (this.isExpired(token.getAccessTokenExpiry())) {
            throw new InvalidTokenException("Access token expired: " + accessTokenValue);
        }
        Authentication userAuthentication = this.getUserAuthentication(token);
        OAuth2Request clientAuthentication = this.getClientAuthentication(token, userAuthentication);
        return new OAuth2Authentication(clientAuthentication, userAuthentication);
    }

    @Nonnull
    private OAuth2Request getClientAuthentication(OAuthToken token, @Nullable Authentication userAuthentication) {
        OAuthClient client = this._clientReadDataService.getClientById(token.getClientId());
        if (client == null) {
            throw new InvalidTokenException("Client for access token " + token.getAccessToken() + " not valid: " + token.getClientId());
        }
        Sets.SetView scope = Sets.intersection(client.getScope(), token.getScope());
        ImmutableMap.Builder requestParameters = ImmutableMap.builder().put((Object)"grant_type", (Object)token.getGrantType()).put((Object)"client_id", (Object)client.getClientId()).put((Object)"scope", (Object)OAuth2Utils.formatParameterList(token.getScope()));
        if (userAuthentication != null) {
            requestParameters.put((Object)"username", (Object)userAuthentication.getName());
        }
        AuthorizationRequest authorizationRequest = new AuthorizationRequest(client.getClientId(), (Collection)scope);
        authorizationRequest.setResourceIdsAndAuthoritiesFromClientDetails((ClientDetails)client);
        authorizationRequest.setRequestParameters((Map)requestParameters.build());
        authorizationRequest.setApproved(true);
        return authorizationRequest.createOAuth2Request();
    }

    @CheckForNull
    private Authentication getUserAuthentication(OAuthToken token) {
        PersonId personId = token.getPersonId();
        if (personId == null) {
            return null;
        }
        DBPerson person = this._personReadDataService.getPersonById(personId);
        if (person == null) {
            throw new InvalidTokenException("User for access token " + token.getAccessToken() + " not valid: Person " + personId + " does not exist!");
        }
        JustConnectUser justConnectUser = SecurityUtils.getJustConnectUser(person);
        this._userDetailsChecker.check((UserDetails)justConnectUser);
        AuthorizationContext authorizationContextForUser = this._authorizationContextProvider.getAuthorizationContextForUser(personId);
        Optional<TenantId> tenantId = authorizationContextForUser.getOptionalTenantId();
        return new JustConnectUserAuthenticationToken(justConnectUser, (String)tenantId.map(AbstractUUIDBasedItemId::asString).orElse(null));
    }

    public boolean revokeToken(String value) {
        return this.revokeToken(this.getTokenByAccessTokenId(this.getAccessTokenId(value)));
    }

    private boolean revokeToken(@Nullable OAuthToken token) {
        if (token != null) {
            return this._tokenWriteDataService.removeTokenByAccessTokenId(token.getAccessToken());
        }
        return false;
    }

    private boolean expireToken(OAuthToken token) {
        return this._tokenWriteDataService.markTokenAsExpired(token, this._clock.now());
    }
}

