/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.ldap.userdetails;

import de.justsoftware.onx.migration.business.impl.DomainResolver;
import de.justsoftware.onx.migration.business.impl.LDAPExternalIdUtil;
import de.justsoftware.onx.migration.business.model.ExternalIdField;
import de.justsoftware.onx.migration.shared.server.model.LDAPPersonIdentifier;
import de.justsoftware.onx.person.business.ExternalPersonAccessor;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.model.JustConnectUser;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.naming.NamingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class JustConnectUserDetailsContextMapper
implements UserDetailsContextMapper {
    @Autowired
    private DomainResolver _domainResolver;
    @Autowired
    private ExternalPersonAccessor _personAccessor;
    @Autowired
    private UserDetailsChecker _userValidator;
    private final ExternalIdField _externalIdField;

    public JustConnectUserDetailsContextMapper(@Nonnull ExternalIdField externalIdField) {
        this._externalIdField = externalIdField;
    }

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        DBPerson dbPerson = this._personAccessor.getPersonByUsername(this.determineExternalId(ctx));
        if (dbPerson == null) {
            throw new UsernameNotFoundException("User known by LDAP username " + username + " not known in DB");
        }
        JustConnectUser user = SecurityUtils.getJustConnectUser(dbPerson);
        this._userValidator.check((UserDetails)user);
        return user;
    }

    @Nonnull
    private String determineExternalId(@Nonnull DirContextOperations ctx) {
        try {
            String externalId = LDAPExternalIdUtil.getExternalIdAsString(ctx, this._externalIdField);
            if (externalId == null) {
                throw new NamingException("Unable to find external id in field \"" + this._externalIdField.getFieldName() + "\".");
            }
            LDAPPersonIdentifier identifier = LDAPPersonIdentifier.fromName(this._externalIdField.getFieldName(), externalId, this._domainResolver.getDomain(ctx.getDn()));
            return identifier.toExternalIdString();
        }
        catch (NamingException e) {
            throw new InternalAuthenticationServiceException("error getting external ID", (Throwable)LdapUtils.convertLdapException((NamingException)e));
        }
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        throw new UnsupportedOperationException("transforming a user to a directory entry is not supported");
    }
}

