/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.jwt;

import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.generator.JwtGenerators;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.keys.SecretKeyCache;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.jwtfilter.verifier.JwtVerifiers;
import de.justsoftware.onx.zookeeper.JwtSigningKeyConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class SignedJwtConfiguration {
    private final SecretKeyCache _keyCache = new SecretKeyCache(jwtSigningKeyConfiguration::getJWTSignatureKey);

    @Autowired
    public SignedJwtConfiguration(JwtSigningKeyConfiguration jwtSigningKeyConfiguration) throws JwtKeyLoadingException {
    }

    @Bean(name={"signedJwtVerifier"})
    @Nonnull
    public JwtVerifier signedJwtVerifier() {
        return JwtVerifiers.createSignedPlaintextTokenVerifier((SecretKeyCache)this._keyCache);
    }

    @Nonnull
    @Bean(name={"signedJwtGenerator"})
    public JwtGenerator signedJwtGenerator() {
        return JwtGenerators.createPlaintextSignedJwtGenerator((SecretKeyCache)this._keyCache);
    }
}

