/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.jwt;

import de.justsoftware.jwtfilter.generator.JwtClaimsBuilder;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.security.jwt.JwtConfigurationException;
import de.justsoftware.onx.security.jwt.JwtService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jose4j.lang.JoseException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class JwtServiceImpl
implements JwtService {
    private final JwtGenerator _jwtGenerator;

    public JwtServiceImpl(@Qualifier(value="encryptedJwtGenerator") JwtGenerator jwtGenerator) {
        this._jwtGenerator = jwtGenerator;
    }

    @Override
    @Nonnull
    public String createLoginJWT(PersonId personId, @Nullable TenantId tenantId, int lifetime) {
        JwtClaimsBuilder claimsBuilder = new JwtClaimsBuilder().withLifetime((long)lifetime).withSubject(personId.toString());
        if (tenantId != null) {
            claimsBuilder.withCustomClaim("tenantId", tenantId.asString());
        }
        try {
            return this._jwtGenerator.generateJWT(claimsBuilder);
        }
        catch (JwtKeyLoadingException | JoseException e) {
            throw new JwtConfigurationException((Exception)e);
        }
    }
}

