/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.jwt;

import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.util.CookieUtil;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.security.jwt.JwtConfigurationException;
import de.justsoftware.onx.security.jwt.JwtCookieManager;
import de.justsoftware.onx.security.jwt.JwtService;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.stereotype.Service;

@Service(value="jwtCookieManager")
@ParametersAreNonnullByDefault
public class JwtCookieManagerImpl
implements AuthenticationSuccessHandler,
RememberMeServices,
LogoutHandler,
JwtCookieManager {
    private static final Logger LOG = LoggerFactory.getLogger(JwtCookieManagerImpl.class);
    private static final String JUST_ID_COOKIE_NAME = "just-id";
    private final int _sessionTimeout;
    private final PersonTenantService _personTenantService;
    private final JwtService _jwtService;
    private final AuthorizationContextProvider _authorizationContextProvider;

    @Autowired
    public JwtCookieManagerImpl(@Value(value="${sessionTimeout}") int sessionTimeout, PersonTenantService personTenantService, JwtService jwtService, AuthorizationContextProvider authorizationContextProvider) {
        this._sessionTimeout = sessionTimeout;
        this._personTenantService = personTenantService;
        this._jwtService = jwtService;
        this._authorizationContextProvider = authorizationContextProvider;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication auth) {
        this.removeCookie(request, response);
    }

    public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        this.removeCookie(request, response);
    }

    public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.addCookie(request, response, authentication);
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.loginSuccess(request, response, authentication);
    }

    @Override
    public void addCookie(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        String jwtToken = this.createJwt(authentication);
        if (jwtToken != null) {
            CookieUtil.newCookie(JUST_ID_COOKIE_NAME, jwtToken).maxAge(-1).httpOnly(true).request(request).path("/").add(response);
        } else {
            this.removeCookie(request, response);
        }
    }

    @Override
    public void autoLoginNewTenant(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.loginSuccess(request, response, authentication);
    }

    private void removeCookie(HttpServletRequest request, HttpServletResponse response) {
        CookieUtil.removeCookie(JUST_ID_COOKIE_NAME, request, response);
    }

    @Override
    public String createJwt(AuthorizationContextWithUserId authContext) {
        return this._jwtService.createLoginJWT(authContext.getUserId(), authContext.getOptionalTenantId().orElse(null), this._sessionTimeout);
    }

    @CheckForNull
    private String createJwt(Authentication successfulAuthentication) throws JwtConfigurationException {
        PersonId personId = SecurityUtils.getUserIdOrNull(successfulAuthentication);
        if (personId == null) {
            return null;
        }
        if (successfulAuthentication instanceof UsernamePasswordAuthenticationToken) {
            return this.createJwt(this._authorizationContextProvider.getAuthorizationContextForUser(personId));
        }
        Optional<TenantId> optionalTenantId = SecurityUtils.getTenantId();
        TenantId tenantId = optionalTenantId.or(() -> this._personTenantService.getTenantIdsForPerson(personId).stream().findFirst()).orElse(null);
        return this._jwtService.createLoginJWT(personId, tenantId, this._sessionTimeout);
    }
}

