/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.jwt;

import de.justsoftware.onx.security.model.ExternalLoginAuthenticationToken;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class ExternalLoginAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalLoginAuthenticationFilter.class);

    public ExternalLoginAuthenticationFilter(@Nonnull String defaultFilterProcessesUrl) {
        super(defaultFilterProcessesUrl);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        LOG.debug("Attempt login with JWT token");
        String header = request.getHeader("Authorization");
        String authToken = null;
        if (header != null) {
            if (!header.startsWith("Bearer ")) {
                throw new AuthenticationServiceException("No JWT token found in Authorization header");
            }
            authToken = header.substring(7);
            LOG.debug("JWT token supplied as header");
        } else {
            authToken = request.getParameter("jwt");
            if (authToken == null) {
                throw new AuthenticationServiceException("Neither JWT token found in Authorization header nor as request parameter");
            }
            LOG.debug("JWT token supplied as request parameter");
        }
        return this.getAuthenticationManager().authenticate((Authentication)new ExternalLoginAuthenticationToken(authToken));
    }
}

