/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.security.jwt;

import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.generator.JwtGenerators;
import de.justsoftware.jwtfilter.keys.KeyMaterialProvider;
import de.justsoftware.jwtfilter.keys.PublicKeyCache;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.jwtfilter.verifier.JwtVerifiers;
import de.justsoftware.onx.zookeeper.JwtKeyConfiguration;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class EncryptedJwtConfiguration {
    private PublicKeyCache _keyCache;
    @Autowired
    private JwtKeyConfiguration _jwtKeyConfiguration;

    @PostConstruct
    public void setup() {
        KeyMaterialProvider privKeyProvider = () -> Optional.ofNullable(this._jwtKeyConfiguration.getPrivateKey());
        KeyMaterialProvider pubKeyProvider = () -> Optional.ofNullable(this._jwtKeyConfiguration.getPublicKey());
        this._keyCache = new PublicKeyCache(privKeyProvider, pubKeyProvider);
    }

    @Nonnull
    @Bean(value={"encryptedJwtVerifier"})
    public JwtVerifier provideJwtVerifier() {
        return JwtVerifiers.createEncryptedTokenVerifier((PublicKeyCache)this._keyCache);
    }

    @Nonnull
    @Bean(value={"encryptedJwtGenerator"})
    public JwtGenerator provideJwtGenerator() {
        return JwtGenerators.createEncryptedJwtGenerator((PublicKeyCache)this._keyCache);
    }
}

