/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.secret.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.secret.business.AesSectretKey;
import de.justsoftware.onx.secret.business.HMacSecretKey;
import de.justsoftware.onx.secret.business.MasterKeyProvider;
import de.justsoftware.onx.secret.business.SaltSecretKey;
import de.justsoftware.onx.secret.business.SecretKey;
import de.justsoftware.onx.secret.business.SecretKeyName;
import de.justsoftware.onx.secret.business.SecretService;
import de.justsoftware.onx.secret.business.integration.persistence.SecretDAO;
import de.justsoftware.onx.util.server.AESRandomIvEncodeDecoder;
import de.justsoftware.onx.util.server.AbstractEncoderDecoder;
import de.justsoftware.onx.util.server.Base64EncoderDecoder;
import de.justsoftware.onx.util.server.EncoderDecoder;
import de.justsoftware.onx.util.server.JucoSecurityException;
import de.justsoftware.onx.util.server.MD5Util;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecretServiceImpl
implements SecretService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SecretServiceImpl.class);
    private final SecretDAO _secretDAO;
    private ImmutableMap<SecretKeyName, SecretKey> _keyCache = null;
    private final MasterKeyProvider _masterKeyProvider;

    @Autowired
    @ParametersAreNonnullByDefault
    public SecretServiceImpl(SecretDAO secretDAO, MasterKeyProvider masterKeyProvider) {
        this._secretDAO = secretDAO;
        this._masterKeyProvider = masterKeyProvider;
    }

    @Override
    public <S extends SecretKey> S getSecretKey(SecretKeyName name) {
        SecretKey cast = (SecretKey)this.loadKeys().get((Object)name);
        return (S)cast;
    }

    @Nonnull
    private ImmutableMap<SecretKeyName, SecretKey> loadKeys() {
        if (this._keyCache == null) {
            this._keyCache = this.loadKeyCache();
        }
        return this._keyCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private ImmutableMap<SecretKeyName, SecretKey> loadKeyCache() {
        ImmutableMap<SecretKeyName, String> allValuesFromDb;
        byte[] masterKey;
        ImmutableMap<SecretKeyName, String> valuesFromDb = this._secretDAO.loadAll();
        if (!this._masterKeyProvider.masterKeyExistent()) {
            if (!valuesFromDb.isEmpty()) throw new JucoSecurityException("keys already generated for a different master key, you should not manipulate them");
            masterKey = this._masterKeyProvider.generateKey();
        } else {
            masterKey = this._masterKeyProvider.getMasterKey();
        }
        ImmutableSet keyNames = ImmutableSet.copyOf((Object[])SecretKeyName.values());
        Sets.SetView missing = Sets.difference((Set)keyNames, (Set)valuesFromDb.keySet());
        if (!missing.isEmpty()) {
            try {
                this.generateMissingSecrets((Set<SecretKeyName>)missing, masterKey);
            }
            catch (RuntimeException e) {
                LOG.warn("Exception during secret generation, trying to load again");
            }
            allValuesFromDb = this._secretDAO.loadAll();
        } else {
            allValuesFromDb = valuesFromDb;
        }
        if (!allValuesFromDb.keySet().equals((Object)keyNames)) {
            throw new JucoSecurityException("key sets don't match");
        }
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (SecretKeyName name : SecretKeyName.values()) {
            resultBuilder.put((Object)name, (Object)SecretServiceImpl.createEncoder(name, masterKey).decode((String)allValuesFromDb.get((Object)name)));
        }
        return resultBuilder.build();
    }

    private void generateMissingSecrets(@Nonnull Set<SecretKeyName> missing, @Nonnull byte[] masterKey) {
        for (SecretKeyName missingKey : missing) {
            SecretKey generatedKey = SecretServiceImpl.generateKey(missingKey);
            this._secretDAO.insert(missingKey, SecretServiceImpl.createEncoder(missingKey, masterKey).encode(generatedKey));
        }
    }

    @Nonnull
    @VisibleForTesting
    static SecretKey generateKey(@Nonnull SecretKeyName name) {
        return name.accept(new SecretKeyName.Visitor<SecretKey>(){

            @Override
            public SecretKey visitLikeUnsubscribeLink() {
                return AesSectretKey.generate();
            }

            @Override
            public SecretKey visitWorkstreamDocumentUpload() {
                return AesSectretKey.generate();
            }

            @Override
            public SecretKey visitRememberMeCookieSecret() {
                return HMacSecretKey.generate();
            }

            @Override
            public SecretKey visitResetPasswordSecret() {
                return HMacSecretKey.generate();
            }

            @Override
            public SecretKey visitActivateNewEmailSecret() {
                return HMacSecretKey.generate();
            }

            @Override
            public SecretKey visitTransportLoginSecret() {
                return HMacSecretKey.generate();
            }

            @Override
            public SecretKey visitUserActivationSecret() {
                return HMacSecretKey.generate();
            }

            @Override
            public SecretKey visitDocumentVersionSalt() {
                return SaltSecretKey.generate();
            }

            @Override
            public SecretKey visitLinkInfoSalt() {
                return SaltSecretKey.generate();
            }
        });
    }

    @Nonnull
    @VisibleForTesting
    static AesSectretKey secretKey(@Nonnull SecretKeyName name, @Nonnull byte[] masterKey) {
        return new AesSectretKey(MD5Util.getByteHash(ArrayUtils.addAll((byte[])masterKey, (byte[])name.name().getBytes(Charsets.US_ASCII))));
    }

    @Nonnull
    @VisibleForTesting
    static EncoderDecoder<SecretKey, String> createEncoder(@Nonnull SecretKeyName name, @Nonnull byte[] masterKey) {
        return new SecretKeyToByteArrayEncoderDecoder(name).wrap(new AESRandomIvEncodeDecoder(SecretServiceImpl.secretKey(name, masterKey))).wrap(Base64EncoderDecoder.INSTANCE);
    }

    public void afterPropertiesSet() {
        this.loadKeyCache();
    }

    private static final class SecretKeyToByteArrayEncoderDecoder
    extends AbstractEncoderDecoder<SecretKey, byte[]> {
        private final SecretKeyName _name;

        private SecretKeyToByteArrayEncoderDecoder(@Nonnull SecretKeyName name) {
            this._name = name;
        }

        @Override
        public byte[] encode(SecretKey plain) {
            return plain.asByteArray();
        }

        @Override
        public SecretKey decode(final byte[] encoded) {
            return this._name.accept(new SecretKeyName.Visitor<SecretKey>(){

                @Override
                public SecretKey visitLikeUnsubscribeLink() {
                    return new AesSectretKey(encoded);
                }

                @Override
                public SecretKey visitWorkstreamDocumentUpload() {
                    return new AesSectretKey(encoded);
                }

                @Override
                public SecretKey visitRememberMeCookieSecret() {
                    return new HMacSecretKey(encoded);
                }

                @Override
                public SecretKey visitResetPasswordSecret() {
                    return new HMacSecretKey(encoded);
                }

                @Override
                public SecretKey visitActivateNewEmailSecret() {
                    return new HMacSecretKey(encoded);
                }

                @Override
                public SecretKey visitTransportLoginSecret() {
                    return new HMacSecretKey(encoded);
                }

                @Override
                public SecretKey visitUserActivationSecret() {
                    return new HMacSecretKey(encoded);
                }

                @Override
                public SecretKey visitDocumentVersionSalt() {
                    return new SaltSecretKey(encoded);
                }

                @Override
                public SecretKey visitLinkInfoSalt() {
                    return new SaltSecretKey(encoded);
                }
            });
        }
    }
}

