/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.secret.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import de.justsoftware.onx.common.shared.server.util.Filenames;
import de.justsoftware.onx.secret.business.AesSectretKey;
import de.justsoftware.onx.secret.business.MasterKeyProvider;
import de.justsoftware.onx.util.server.AESRandomIvEncodeDecoder;
import de.justsoftware.onx.util.server.EncoderDecoder;
import de.justsoftware.onx.util.server.JucoSecurityException;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="masterKeyProvider")
public class FilesystemMasterKeyProvider
implements MasterKeyProvider {
    private static final EncoderDecoder<byte[], byte[]> MASTER_PASSWORD_ENCODER_DECODER = new AESRandomIvEncodeDecoder(new AesSectretKey("vn8vq2nn80xh3bas".getBytes(Charsets.US_ASCII)));
    private final File _file;

    @Autowired
    public FilesystemMasterKeyProvider(@Nullable @Value(value="${master.key.location}") String filename) throws URISyntaxException {
        this(StringUtils.isNotBlank((String)filename) ? new File(Filenames.replaceTildeByUserHome(filename)) : new File(FilesystemMasterKeyProvider.class.getResource("/juco.master.key").toURI()));
    }

    @VisibleForTesting
    FilesystemMasterKeyProvider(@Nonnull File file) {
        this._file = file;
    }

    @Override
    public byte[] getMasterKey() {
        try {
            byte[] encrypted = IOUtils.toByteArray((InputStream)new FileInputStream(this._file));
            return MASTER_PASSWORD_ENCODER_DECODER.decode(encrypted);
        }
        catch (FileNotFoundException e) {
            throw new JucoSecurityException(e);
        }
        catch (IOException e) {
            throw new JucoSecurityException(e);
        }
    }

    @Override
    public byte[] generateKey() {
        if (this.masterKeyExistent()) {
            throw new JucoSecurityException("could not create master key already exist");
        }
        byte[] masterKey = SecureRandomUtil.randomBytes(16);
        byte[] encrypted = MASTER_PASSWORD_ENCODER_DECODER.encode(masterKey);
        try {
            if (!this._file.exists() && !this._file.createNewFile()) {
                throw new JucoSecurityException("could not create master key file!");
            }
            IOUtils.write((byte[])encrypted, (OutputStream)new FileOutputStream(this._file));
        }
        catch (FileNotFoundException e) {
            throw new JucoSecurityException(e);
        }
        catch (IOException e) {
            throw new JucoSecurityException(e);
        }
        return masterKey;
    }

    @Override
    public boolean masterKeyExistent() {
        return this._file.exists() && this._file.length() > 0L;
    }
}

