/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.secret.business;

import de.justsoftware.onx.secret.business.SecretKey;
import de.justsoftware.onx.util.server.SecureRandomUtil;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class HMacSecretKey
implements SecretKey {
    private static final int HMAC_SHA_KEY_LENGTH = 64;
    private final byte[] _key;

    public HMacSecretKey(byte[] key) {
        if (64 != key.length) {
            throw new IllegalArgumentException("Expected key length is 64 but got " + key.length);
        }
        this._key = (byte[])key.clone();
    }

    @Nonnull
    public static HMacSecretKey generate() {
        return new HMacSecretKey(SecureRandomUtil.randomBytes(64));
    }

    @Override
    @Nonnull
    public byte[] asByteArray() {
        return (byte[])this._key.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMacSecretKey that = (HMacSecretKey)o;
        return Arrays.equals(this._key, that._key);
    }

    public int hashCode() {
        return Arrays.hashCode(this._key);
    }
}

