/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.searchnew.business.SearchField;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SearchTermModel {
    public static final Predicate<SearchTermModel> IS_FIELD_NAME_SELECTED = new Predicate<SearchTermModel>(){

        public boolean apply(SearchTermModel input) {
            return input != null && input.isFieldNameSelected();
        }
    };
    public static final Function<SearchTermModel, SearchField> TO_SEARCH_FIELD = new Function<SearchTermModel, SearchField>(){

        public SearchField apply(SearchTermModel input) {
            return input != null ? input.getFieldName() : null;
        }
    };
    public static final Function<SearchTermModel, String> TO_SEARCH_STRING = new Function<SearchTermModel, String>(){

        public String apply(SearchTermModel input) {
            return input != null ? input.getSearchString() : null;
        }
    };
    private final SearchField _fieldName;
    private final String _searchString;

    public SearchTermModel(@Nullable SearchField fieldName, @Nonnull String searchString) {
        this._fieldName = fieldName;
        this._searchString = searchString;
    }

    @CheckForNull
    public SearchField getFieldName() {
        return this._fieldName;
    }

    @Nonnull
    public String getSearchString() {
        return this._searchString;
    }

    public boolean isSearchStringNotEmpty() {
        return StringUtils.isNotBlank((String)this._searchString);
    }

    public boolean isFieldNameSelected() {
        return this._fieldName != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fieldName", (Object)this._fieldName).add("searchString", (Object)this._searchString).toString();
    }
}

