/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.common.shared.model.Type;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.shared.model.DefaultHandlingSearchSuggestModelVisitor;
import de.justsoftware.onx.searchnew.shared.model.EntitySuggest;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.SearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.SearchSuggestModelVisitor;
import java.util.Comparator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class SuggestModel<I extends SearchableId, T extends Type>
implements SearchResultEntry {
    public static final Function<SuggestModel<?, ?>, String> NAME = input -> input != null ? input.getName() : null;
    public static final Function<SuggestModel<?, ?>, SearchableId> ID = input -> input != null ? (SearchableId)input.getId() : null;
    public static final Function<SuggestModel<?, ?>, PersonSuggest> PERSON_SUGGEST = input -> input == null ? null : input.visit(new DefaultHandlingSearchSuggestModelVisitor<PersonSuggest>(){

        @Override
        protected PersonSuggest handleDefault(SuggestModel<?, ?> suggestModel) {
            return null;
        }

        @Override
        public PersonSuggest visitPerson(PersonSuggest person) {
            return person;
        }
    });
    public static final Function<SuggestModel<?, ?>, EntitySuggest> ENTITY_SUGGEST = input -> input == null ? null : input.visit(new DefaultHandlingSearchSuggestModelVisitor<EntitySuggest>(){

        @Override
        protected EntitySuggest handleDefault(SuggestModel<?, ?> suggestModel) {
            return null;
        }

        @Override
        public EntitySuggest visitEntity(EntitySuggest entity) {
            return entity;
        }
    });
    public static final Ordering<SuggestModel<?, ?>> SUGGEST_NAME_ORDERING = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast().onResultOf(NAME);
    private static final long serialVersionUID = -1363892144208066922L;
    private I _id;
    private T _type;
    private String _name;
    private String _htmlHighlightedName;
    private Long _fileTypeId;
    private String _compoundId;
    private String _logo;

    public I getId() {
        return this._id;
    }

    public void setId(I id) {
        this._id = id;
    }

    public T getType() {
        return this._type;
    }

    public void setType(T type) {
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getHtmlHighlightedName() {
        return this._htmlHighlightedName;
    }

    public void setHtmlHighlightedName(String htmlHighlightedName) {
        this._htmlHighlightedName = htmlHighlightedName;
    }

    public Long getFileTypeId() {
        return this._fileTypeId;
    }

    public void setFileTypeId(Long fileTypeId) {
        this._fileTypeId = fileTypeId;
    }

    public String getCompoundId() {
        return this._compoundId;
    }

    public void setCompoundId(String compoundId) {
        this._compoundId = compoundId;
    }

    public String getLogo() {
        return this._logo;
    }

    public void setLogo(String logo) {
        this._logo = logo;
    }

    @CheckForNull
    public abstract <K> K visit(@Nonnull SearchSuggestModelVisitor<K> var1);

    public final String toString() {
        return this.toStringBuilder().toString();
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    protected MoreObjects.ToStringHelper toStringBuilder() {
        return MoreObjects.toStringHelper((Object)this).add("id", this._id).add("type", this._type).add("name", (Object)this._name).add("htmlHighlightedName", (Object)this._htmlHighlightedName).add("fileTypeId", (Object)this._fileTypeId).add("compoundId", (Object)this._compoundId).add("logo", (Object)this._logo);
    }
}

