/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.base.Strings;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.searchnew.shared.model.EntityFilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchResultViewType;
import de.justsoftware.onx.searchnew.shared.model.SearchSubFilterEncoder;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchTokenUtil {
    public static final String SEARCH_TOKEN_PARAM_TYPE = "SSSLLSSS";
    public static final int INDEX_SEARCH_STRING = 0;
    public static final int INDEX_FILTER_TYPE_ID = 1;
    public static final int INDEX_SEARCH_CONTEXT_STRING = 2;
    public static final int INDEX_ENTITY_ID = 3;
    public static final int INDEX_SORT_TYPE_ID = 4;
    public static final int INDEX_SUBFILTER = 5;
    public static final int INDEX_PROVIDER = 6;
    public static final int INDEX_VIEW_TYPE = 7;

    @Nonnull
    public static SearchParameters defaultSearchParameters() {
        return SearchTokenUtil.parameters("", StaticFilterType.PROFILES, SearchContext.ENTIRE_PLATFORM, null, null, null, SearchProviderId.JUCO_ID);
    }

    @Nonnull
    public static final Object[] toSearchTokenParamArray(SearchParameters input, @Nullable SearchResultViewType targetViewType) {
        FilterType selectedFilter = input.getFilterType();
        SearchContext searchContext = input.getSearchContext();
        GlobalId selectedContextId = input.getContextId();
        SortType selectedSortType = input.getSortType();
        return new Object[]{input.getText(), selectedFilter != null ? selectedFilter.getName() : null, searchContext != null ? searchContext.name() : null, selectedContextId, selectedSortType != null ? Long.valueOf(selectedSortType.getId()) : null, SearchSubFilterEncoder.encode(input.getSubfilter()), !input.getSearchProvider().equals(SearchProviderId.JUCO_ID) ? input.getSearchProvider().getId() : null, targetViewType != null && !SearchResultViewType.getDefault().equals((Object)targetViewType) ? targetViewType.toParam() : null};
    }

    @Nonnull
    public static SearchParameters convertParamsToSearchParameters(List<?> params, @Nullable EntityId currentEntityId) {
        String searchString = (String)params.get(0);
        FilterType selectedFilter = FilterTypes.valueOf((String)params.get(1));
        SearchContext searchContext = SearchContext.getByName((String)params.get(2));
        SortType sortType = SortType.getById((Long)params.get(4));
        EntityId selectedEntityId = SearchTokenUtil.getEntityId(params, currentEntityId);
        Set<SubFilter> selectedSubFilter = SearchTokenUtil.getSubFilter(params, selectedFilter, 5);
        SearchProviderId provider = SearchTokenUtil.getSearchProviderId(params);
        return SearchTokenUtil.parameters(searchString, selectedFilter, searchContext, selectedEntityId, sortType, selectedSubFilter, provider);
    }

    @Nonnull
    private static SearchParameters parameters(@Nullable String searchString, @Nullable FilterType filter, @Nullable SearchContext context, @Nullable EntityId entityId, @Nullable SortType sortType, @Nullable Set<SubFilter> subfilter, SearchProviderId provider) {
        return new SearchParameters(searchString, filter, context, entityId, null, sortType, subfilter, provider, StaticSearchFacetParameters.DEFAULT_FACETS);
    }

    @CheckForNull
    private static EntityId getEntityId(List<?> params, @Nullable EntityId currentEntityId) {
        return params.size() > 3 && params.get(3) != null ? new EntityId((Long)params.get(3)) : currentEntityId;
    }

    @CheckForNull
    public static Set<SubFilter> getSubFilter(List<?> params, @Nullable FilterType selectedFilter, int subFilterIndex) {
        if (params.size() <= subFilterIndex) {
            return null;
        }
        EntityType entityType = selectedFilter instanceof EntityFilterType ? ((EntityFilterType)selectedFilter).getType() : null;
        return SearchSubFilterEncoder.decode((String)params.get(subFilterIndex), entityType);
    }

    @Nonnull
    private static SearchProviderId getSearchProviderId(List<?> params) {
        if (params.size() <= 6) {
            return SearchProviderId.JUCO_ID;
        }
        String providerString = (String)params.get(6);
        if (Strings.isNullOrEmpty((String)providerString)) {
            return SearchProviderId.JUCO_ID;
        }
        try {
            Long oldParam = Long.valueOf((String)params.get(6));
            if (oldParam != null) {
                return SearchProviderId.JUCO_ID;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new SearchProviderId(providerString);
    }
}

