/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterId;
import de.justsoftware.onx.searchnew.shared.model.StaticSearchFacetParameters;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SearchTextBoxFilterModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String WILDCARD = "*";
    private SearchTextBoxFilterId _id;
    private SearchContext _searchContext;
    private SearchProviderId _searchProviderId;
    private FilterType _filter;
    private String _searchField;
    private boolean _wildcardSearch;

    @Deprecated
    public SearchTextBoxFilterModel() {
    }

    public SearchTextBoxFilterModel(SearchTextBoxFilterId id, SearchContext searchContext, SearchProviderId searchProviderId, FilterType filter, @Nullable String searchField, boolean wildcardSearch) {
        this._id = id;
        this._searchContext = searchContext;
        this._searchProviderId = searchProviderId;
        this._filter = filter;
        this._searchField = searchField;
        this._wildcardSearch = wildcardSearch;
    }

    @Nonnull
    public SearchTextBoxFilterId getId() {
        return this._id;
    }

    @Nonnull
    public SearchContext getSearchContext() {
        return this._searchContext;
    }

    @Nonnull
    public SearchProviderId getSearchProviderId() {
        return this._searchProviderId;
    }

    @Nonnull
    public FilterType getFilter() {
        return this._filter;
    }

    @CheckForNull
    public String getSearchField() {
        return this._searchField;
    }

    public boolean isWildcardSearch() {
        return this._wildcardSearch;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("searchContext", (Object)this._searchContext).add("searchProviderId", (Object)this._searchProviderId).add("filter", (Object)this._filter).add("searchField", (Object)this._searchField).add("wildcardSearch", this._wildcardSearch).toString();
    }

    @Nonnull
    private String toWildcardIfNecessary(String term) {
        String trimmedTerm = term.trim();
        if (!this._wildcardSearch || StringUtil.isBlank(trimmedTerm)) {
            return trimmedTerm;
        }
        StringBuffer result = new StringBuffer();
        if (!trimmedTerm.startsWith(WILDCARD)) {
            result.append(WILDCARD);
        }
        result.append(trimmedTerm);
        if (!trimmedTerm.endsWith(WILDCARD)) {
            result.append(WILDCARD);
        }
        return result.toString();
    }

    @CheckForNull
    @VisibleForTesting
    String toSearchString(@Nullable String searchQuery) {
        if (searchQuery == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtil.isBlank(this._searchField) && !StringUtil.isBlank(searchQuery)) {
            String[] searchTerms;
            String searchField = this._searchField.trim();
            for (String searchTerm : searchTerms = searchQuery.split(" ")) {
                if (StringUtil.isBlank(searchTerm)) continue;
                result.append(searchField).append(":").append(this.toWildcardIfNecessary(searchTerm)).append(" ");
            }
        } else {
            result.append(this.toWildcardIfNecessary(searchQuery));
        }
        return result.toString().trim();
    }

    @Nonnull
    public SearchParameters toSearchParameters(@Nullable String searchQuery) {
        return new SearchParameters(this.toSearchString(searchQuery), this._filter, this._searchContext, null, null, null, null, this._searchProviderId, StaticSearchFacetParameters.DEFAULT_FACETS);
    }
}

