/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.shared.model;

import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.common.shared.util.Enums2;
import de.justsoftware.onx.common.shared.util.Multimaps2;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityStatusId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.BlockSubFilter;
import de.justsoftware.onx.searchnew.shared.model.CoadminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DocumentFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DriveFileTypeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.EntityStatusSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritAdminSubFilter;
import de.justsoftware.onx.searchnew.shared.model.InheritMemberSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ModificationDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.OrSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonIdSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PersonRoleSubFilter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.PublicationDateFilter;
import de.justsoftware.onx.searchnew.shared.model.StartAndEndDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.StartDateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterVisitor;
import de.justsoftware.onx.searchnew.shared.model.TagSubFilter;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class SearchSubFilterEncoder {
    private static final char SUBFILTER_SEPARATOR = '&';
    private static final char KEY_VALUE_SEPARATOR = '-';
    private static final char MULTI_VALUE_SEPARATOR = ',';
    private static final char ESCAPE_CHARACTER = '/';
    private static final String EMPTY_VALUE = "emptyVal";
    private static final Joiner MULTIPLE_VALUE_JOINER = Joiner.on((char)',').skipNulls();
    private static final Escaper VALUE_ESCAPER = Escapers.builder().addEscape(',', "/,").addEscape('-', "/-").addEscape('&', "/&").addEscape('/', "//").build();
    private static final Function<String, String> VALUE_ESCAPE_FUNCTION = new NullPermeableFunction<String, String>(){

        @Override
        protected String applySafe(String input) {
            return VALUE_ESCAPER.escape(input);
        }
    };

    private SearchSubFilterEncoder() {
    }

    @Nonnull
    public static Set<SubFilter> decode(@Nullable String subfilterParam, @Nullable EntityType entityType) {
        if (StringUtil.isBlank(subfilterParam)) {
            return ImmutableSet.of();
        }
        return new SubfilterTokenParser(entityType).parse(subfilterParam);
    }

    @CheckForNull
    public static String encode(@Nullable Set<SubFilter> subfilter) {
        if (CollectionUtil.isEmpty(subfilter)) {
            return null;
        }
        return Multimaps2.joinMultimap(Iterables.transform(subfilter, input -> input != null ? input.accept(new SubFilterToURLTokenVisitor()) : null), Joiner.on((char)'&').skipNulls(), Joiner.on((char)'-').skipNulls());
    }

    @ParametersAreNonnullByDefault
    private static class SubFilterToURLTokenVisitor
    implements SubFilterVisitor<Map.Entry<String, String>> {
        private SubFilterToURLTokenVisitor() {
        }

        @Override
        public Map.Entry<String, String> visitDateSubFilter(DateSubFilter subfilter) {
            return this.createSingleValueEntry(SubFilterUrlKey.ENTITY_DATEFILTER, subfilter, Enums2.NAME);
        }

        @Override
        public Map.Entry<String, String> visitStartAndEndDateSubFilter(StartAndEndDateSubFilter filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitStartDateSubFilter(StartDateSubFilter filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitPersonRoleSubFilter(PersonRoleSubFilter filter) {
            return this.createMultiValueEntry(SubFilterUrlKey.PERSON_ROLE, (Iterable)filter.getFilterValues(), (Function)Functions.identity(), false);
        }

        @Override
        public Map.Entry<String, String> visitPersonIdSubFilter(PersonIdSubFilter personIdSubFilter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitOrSubFilter(OrSubFilter orSubFilter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitEntityMemberSubFilter(EntityMemberSubFilter entityMemberSubFilter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitPublicationDate(PublicationDateFilter publicationDateFilter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitDocumentFileType(DocumentFileTypeSubFilter subfilter) {
            return this.createMultiValueEntry(SubFilterUrlKey.DOCUMENT_TYPE, (Iterable)subfilter.getFilterValues(), (Function)Functions.toStringFunction(), false);
        }

        @Override
        public Map.Entry<String, String> visitModificationDate(ModificationDateSubFilter subfilter) {
            return this.createSingleValueEntry(SubFilterUrlKey.MODIFICATION_DATE_FILTER, subfilter, Enums2.NAME);
        }

        @Override
        public Map.Entry<String, String> visitEntityDynamicAttributeSubFilter(EntityDynamicAttributeSubFilter subFilter) {
            return this.createMultiValueEntry(SubFilterUrlKey.ENTITY_DYNAMIC_ATTRIBUTE, Iterables.concat((Iterable)ImmutableSet.of((Object)subFilter.getAttributeId().getId()), subFilter.getFilterValues()), Functions.identity(), false);
        }

        @Override
        public Map.Entry<String, String> visitInheritMemberSubFilter(InheritMemberSubFilter inheritMemberSubFilter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitInheritAdminSubFilter(InheritAdminSubFilter inheritAdminSubFilter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitCoadminSubFilter(CoadminSubFilter coadminSubFilter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map.Entry<String, String> visitArchiveSubFilter(ArchiveSubFilter archiveSubFilter) {
            return this.createSingleValueEntry(SubFilterUrlKey.ARCHIVE_FILTER, archiveSubFilter, Enums2.NAME);
        }

        @Override
        public Map.Entry<String, String> visitBlockedSubFilter(BlockSubFilter blockedSubFilter) {
            return this.createSingleValueEntry(SubFilterUrlKey.BLOCK_FILTER, blockedSubFilter, Enums2.NAME);
        }

        @Override
        public Map.Entry<String, String> visitEntityStatusSubFilter(EntityStatusSubFilter entityStatusSubFilter) {
            return this.createMultiValueEntry(SubFilterUrlKey.ENTITY_STATUSFILTER, (Iterable)entityStatusSubFilter.getStatusIds(), (Function)Functions.compose((Function)Functions.toStringFunction(), LongId.TO_LONG), false);
        }

        @Override
        public Map.Entry<String, String> visitTagSubFilter(TagSubFilter tagSubFilter) {
            return this.createMultiValueEntry(SubFilterUrlKey.TAG_FILTER, (Iterable)tagSubFilter.getFilterValues(), (Function)Functions.identity(), false);
        }

        @Override
        public Map.Entry<String, String> visitDriveFileTypeSubFilter(DriveFileTypeSubFilter driveFileTypeSubFilter) {
            return this.createMultiValueEntry(SubFilterUrlKey.FILE_TYPE_FILTER, (Iterable)driveFileTypeSubFilter.getFilterValues(), (Function)Functions.identity(), false);
        }

        @Override
        public Map.Entry<String, String> visitProfileAttributeSubFilter(ProfileAttributeSubFilter subFilter) {
            return this.createMultiValueEntry(SubFilterUrlKey.PROFILE_ATTRIBUTE, Iterables.concat((Iterable)ImmutableSet.of((Object)subFilter.getName()), subFilter.getFilterValues()), Functions.identity(), false);
        }

        @Nonnull
        private <T> Map.Entry<String, String> createSingleValueEntry(SubFilterUrlKey key, T value, Function<? super T, String> toStringFunction) {
            return Maps.immutableEntry((Object)key._key, (Object)VALUE_ESCAPER.escape((String)toStringFunction.apply(value)));
        }

        @Nonnull
        private <T> Map.Entry<String, String> createMultiValueEntry(SubFilterUrlKey key, Iterable<T> values, Function<? super T, String> toStringFunction, boolean includeEmptyValue) {
            FluentIterable stringValues = FluentIterable.from(values).transform(toStringFunction).transform(VALUE_ESCAPE_FUNCTION);
            return Maps.immutableEntry((Object)key._key, (Object)MULTIPLE_VALUE_JOINER.join((Iterable)(includeEmptyValue ? stringValues.append((Object[])new String[]{SearchSubFilterEncoder.EMPTY_VALUE}) : stringValues)));
        }

        @Override
        public Map.Entry<String, String> visitDriveDocumentTypeSubFilter(DriveDocumentTypeSubFilter driveDocumentTypeSubfilter) {
            return this.createMultiValueEntry(SubFilterUrlKey.DRIVE_DOCUMENT_TYPE, (Iterable)driveDocumentTypeSubfilter.getFilterValues(), (Function)Enum::name, false);
        }
    }

    @ParametersAreNonnullByDefault
    private static final class SubfilterTokenParser {
        private ImmutableSet.Builder<SubFilter> _result = ImmutableSet.builder();
        private String _key;
        private ImmutableList.Builder<String> _values = ImmutableList.builder();
        private StringBuilder _currentString = new StringBuilder();
        private final EntityType _entityType;

        SubfilterTokenParser(@Nullable EntityType entityType) {
            this._entityType = entityType;
        }

        private void resetParser() {
            this._result = ImmutableSet.builder();
        }

        @Nonnull
        ImmutableSet<SubFilter> parse(String token) {
            this.resetParser();
            int curPos = 0;
            boolean inEscape = false;
            int length = token.length();
            block6: while (curPos < length) {
                char ch = token.charAt(curPos++);
                switch (ch) {
                    case '/': {
                        if (inEscape) {
                            this._currentString.append(ch);
                        }
                        inEscape = !inEscape;
                        continue block6;
                    }
                    case '&': {
                        if (inEscape) {
                            this._currentString.append(ch);
                            inEscape = false;
                            continue block6;
                        }
                        this.addFilterValue();
                        this.addFilterToResult();
                        continue block6;
                    }
                    case '-': {
                        if (inEscape) {
                            this._currentString.append(ch);
                            inEscape = false;
                            continue block6;
                        }
                        this._key = this._currentString.toString();
                        this._currentString = new StringBuilder();
                        continue block6;
                    }
                    case ',': {
                        if (inEscape) {
                            this._currentString.append(ch);
                            inEscape = false;
                            continue block6;
                        }
                        this.addFilterValue();
                        continue block6;
                    }
                }
                if (inEscape) {
                    inEscape = false;
                    this._currentString = new StringBuilder();
                }
                this._currentString.append(ch);
            }
            this.addFilterValue();
            this.addFilterToResult();
            return this._result.build();
        }

        private void addFilterToResult() {
            Set<? extends SubFilter> subfilter = this.createSubfilter(this._key, (ImmutableList<String>)this._values.build());
            if (subfilter != null) {
                this._result.addAll(subfilter);
            }
            this._key = null;
            this._values = ImmutableList.builder();
        }

        private void addFilterValue() {
            String trimmedValue = ClientStringUtil.trimToNull(this._currentString.toString());
            if (trimmedValue != null) {
                this._values.add((Object)trimmedValue);
            }
            this._currentString = new StringBuilder();
        }

        @CheckForNull
        private Set<? extends SubFilter> createSubfilter(String key, ImmutableList<String> values) {
            SubFilterUrlKey filterUrlKey = SubFilterUrlKey.getByKey(ClientStringUtil.trimToNull(key));
            if (filterUrlKey != null && !values.isEmpty()) {
                return filterUrlKey.createFilter(values, this._entityType);
            }
            return null;
        }
    }

    @ParametersAreNonnullByDefault
    private static enum SubFilterUrlKey {
        ENTITY_DATEFILTER("ED"){

            ImmutableSet<DateSubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return FluentIterable.from(values).transform(DateSubFilter.FROM_NAME).filter(Predicates.notNull()).toSet();
            }
        }
        ,
        ENTITY_STATUSFILTER("ES"){

            @Override
            ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                if (entityType != null) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    for (String string : values) {
                        try {
                            builder.add((Object)new EntityStatusId(Long.parseLong(string)));
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    return ImmutableSet.of((Object)new EntityStatusSubFilter(entityType, (ImmutableSet<EntityStatusId>)builder.build()));
                }
                return null;
            }
        }
        ,
        ENTITY_ASSIGNEE("EA"){

            @Override
            ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return null;
            }
        }
        ,
        PERSON_ROLE("PR"){

            @Override
            ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return ImmutableSet.of((Object)new PersonRoleSubFilter((ImmutableSet<String>)ImmutableSet.copyOf(values)));
            }
        }
        ,
        PROFILE_ATTRIBUTE("PA"){

            @Override
            ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                if (values.size() < 2) {
                    return null;
                }
                return ImmutableSet.of((Object)new ProfileAttributeSubFilter((String)Iterables.get(values, (int)0), (ImmutableSet<String>)ImmutableSet.copyOf((Iterable)Iterables.skip(values, (int)1))));
            }
        }
        ,
        DOCUMENT_TYPE("DT"){

            @Override
            ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (String string : values) {
                    try {
                        builder.add((Object)Long.valueOf(string));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ImmutableSet filterValues = builder.build();
                return !filterValues.isEmpty() ? ImmutableSet.of((Object)new DocumentFileTypeSubFilter((ImmutableSet<Long>)filterValues)) : null;
            }
        }
        ,
        MODIFICATION_DATE_FILTER("MD"){

            ImmutableSet<ModificationDateSubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return FluentIterable.from(values).transform(ModificationDateSubFilter.FROM_NAME).filter(Predicates.notNull()).toSet();
            }
        }
        ,
        ENTITY_DYNAMIC_ATTRIBUTE("EDA"){

            @Override
            ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                if (entityType == null || values.size() < 2) {
                    return null;
                }
                return ImmutableSet.of((Object)new EntityDynamicAttributeSubFilter(new DynamicAttributeId((String)values.get(0)), entityType, (ImmutableSet<String>)ImmutableSet.copyOf((Iterable)Iterables.skip(values, (int)1))));
            }
        }
        ,
        ARCHIVE_FILTER("AR"){

            ImmutableSet<ArchiveSubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return FluentIterable.from(values).transform(ArchiveSubFilter.FROM_NAME).filter(Predicates.notNull()).toSet();
            }
        }
        ,
        BLOCK_FILTER("BL"){

            ImmutableSet<BlockSubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return FluentIterable.from(values).transform(BlockSubFilter.FROM_NAME).filter(Predicates.notNull()).toSet();
            }
        }
        ,
        TAG_FILTER("TA"){

            ImmutableSet<TagSubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return ImmutableSet.of((Object)new TagSubFilter((ImmutableSet<String>)ImmutableSet.copyOf(values)));
            }
        }
        ,
        FILE_TYPE_FILTER("FT"){

            ImmutableSet<DriveFileTypeSubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                return ImmutableSet.of((Object)new DriveFileTypeSubFilter((ImmutableSet<String>)ImmutableSet.copyOf(values)));
            }
        }
        ,
        DRIVE_DOCUMENT_TYPE("DDT"){

            @Override
            ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> values, @Nullable EntityType entityType) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (String string : values) {
                    try {
                        builder.add((Object)DriveDocumentSearchResultBadgeModel.DocumentType.valueOf(string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                ImmutableSet filterValues = builder.build();
                return !filterValues.isEmpty() ? ImmutableSet.of((Object)new DriveDocumentTypeSubFilter((ImmutableSet<DriveDocumentSearchResultBadgeModel.DocumentType>)filterValues)) : null;
            }
        };

        private static final ImmutableMap<String, SubFilterUrlKey> BY_KEY;
        private final String _key;

        private SubFilterUrlKey(String key) {
            this._key = key;
        }

        @CheckForNull
        abstract ImmutableSet<? extends SubFilter> createFilter(ImmutableList<String> var1, @Nullable EntityType var2);

        @CheckForNull
        public static SubFilterUrlKey getByKey(@Nullable String key) {
            return (SubFilterUrlKey)((Object)BY_KEY.get((Object)key));
        }

        static {
            BY_KEY = Maps.uniqueIndex(Arrays.asList(SubFilterUrlKey.values()), (Function)new NullPermeableFunction<SubFilterUrlKey, String>(){

                @Override
                protected String applySafe(SubFilterUrlKey input) {
                    return input._key;
                }
            });
        }
    }
}

